/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.shapes;

import java.util.Set;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.obj.shapes.ShapeKeys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.presets.UIDataContextMenu;
import mchorse.bbs_mod.utils.pose.ShapeKeysManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIShapeKeys
extends UIElement {
    public UIStringList list = new UIStringList(l -> this.pick((String)l.get(0), false));
    public UITrackpad value;
    private String group = "";
    private ShapeKeys shapeKeys;

    public UIShapeKeys() {
        this.list.background().h(this.list.scroll.scrollItemSize * 6);
        this.list.cancelScrollEdge();
        this.list.context(() -> new UIDataContextMenu(ShapeKeysManager.INSTANCE, this.group, () -> this.shapeKeys.toData(), data -> {
            String current = (String)this.list.getCurrentFirst();
            this.changedShapeKeys(() -> this.shapeKeys.fromData((MapType)data));
            this.pick(current, true);
        }).tooltips("_CopyShapeKeys", UIKeys.SHAPE_KEYS_CONTEXT_COPY, UIKeys.SHAPE_KEYS_CONTEXT_PASTE, UIKeys.SHAPE_KEYS_CONTEXT_RESET, UIKeys.SHAPE_KEYS_CONTEXT_SAVE, UIKeys.SHAPE_KEYS_CONTEXT_NAME));
        this.value = new UITrackpad(v -> this.setValue(v.floatValue()));
        this.column().vertical().stretch();
        this.add(UI.label(UIKeys.SHAPE_KEYS_TITLE), this.list, this.value);
    }

    public void setShapeKeys(String group, Set<String> keys, ShapeKeys shapeKeys) {
        this.group = group;
        this.shapeKeys = shapeKeys;
        this.list.add(keys);
        this.list.sort();
        this.pick((String)this.list.getList().get(0), true);
    }

    protected void changedShapeKeys(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    protected void setValue(float v) {
        this.shapeKeys.shapeKeys.put((String)this.list.getCurrentFirst(), Float.valueOf(v));
    }

    private void pick(String key, boolean select) {
        this.value.setValue(this.shapeKeys.shapeKeys.computeIfAbsent(key, k -> Float.valueOf(0.0f)).floatValue());
        if (select) {
            this.list.setCurrentScroll(key);
        }
    }
}

