/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.util.List;
import java.util.Stack;
import mchorse.bbs_mod.ui.utils.Area;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class BoxPacker {
    public static Vector2i pack(List<Area> boxes, int padding) {
        Stack<Area> areas = new Stack<Area>();
        int w = BoxPacker.getInitialWidth(boxes, padding);
        int finalW = 0;
        int finalH = 0;
        boxes.sort((a, b) -> b.h - a.h);
        areas.add(new Area(0, 0, w, Integer.MAX_VALUE));
        block0: for (Area box : boxes) {
            for (int i = areas.size() - 1; i >= 0; --i) {
                Area area = (Area)areas.get(i);
                if (box.w > area.w || box.h > area.h) continue;
                box.x = area.x;
                box.y = area.y;
                finalH = Math.max(finalH, box.y + box.h);
                finalW = Math.max(finalW, box.x + box.w);
                if (box.w == area.w && box.h == area.h) {
                    Area last = (Area)areas.pop();
                    if (i >= areas.size()) continue block0;
                    areas.set(i, last);
                    continue block0;
                }
                if (box.h == area.h) {
                    area.x += box.w;
                    area.w -= box.w;
                    continue block0;
                }
                if (box.w == area.w) {
                    area.y += box.h;
                    area.h -= box.h;
                    continue block0;
                }
                areas.add(new Area(area.x + box.w, area.y, area.w - box.w, box.h));
                area.y += box.h;
                area.h -= box.h;
                continue block0;
            }
        }
        if (padding != 0) {
            for (Area glyph : boxes) {
                glyph.w -= padding;
                glyph.h -= padding;
                glyph.x += padding;
                glyph.y += padding;
            }
            finalW += padding;
            finalH += padding;
        }
        return new Vector2i(finalW, finalH);
    }

    private static int getInitialWidth(List<Area> glyphs, int padding) {
        int totalArea = 0;
        int maxW = 0;
        for (Area box : glyphs) {
            box.w += padding;
            box.h += padding;
            totalArea += box.w * box.h;
            maxW = Math.max(maxW, box.w);
        }
        return (int)Math.max(Math.ceil(Math.sqrt(totalArea)), (double)maxW);
    }
}

