/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.util.Collection;
import org.joml.Vector3i;

public class MathUtils {
    public static final float PI = (float)Math.PI;

    public static float toRad(float degrees) {
        return degrees / 180.0f * (float)Math.PI;
    }

    public static float toDeg(float rad) {
        return rad / (float)Math.PI * 180.0f;
    }

    public static int clamp(int x, int min, int max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static float clamp(float x, float min, float max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static double clamp(double x, double min, double max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static long clamp(long x, long min, long max) {
        return x < min ? min : (x > max ? max : x);
    }

    public static int cycler(int x, Collection collection) {
        return MathUtils.cycler(x, 0, collection.size() - 1);
    }

    public static int cycler(int x, int min, int max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static float cycler(float x, float min, float max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static double cycler(double x, double min, double max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static int gridIndex(int x, int y, int size, int width) {
        return (x /= size) + (y /= size) * width / size;
    }

    public static int gridRows(int count, int size, int width) {
        double x = (double)(count * size) / (double)width;
        return count <= 0 ? 1 : (int)Math.ceil(x);
    }

    public static int toChunk(float x, int chunkSize) {
        return (int)((x < 0.0f ? x - (float)(chunkSize - 1) : x) / (float)chunkSize);
    }

    public static int toChunk(double x, int chunkSize) {
        return (int)((x < 0.0 ? x - (double)(chunkSize - 1) : x) / (double)chunkSize);
    }

    public static Vector3i toBlock(int i, int w, int h, Vector3i vector) {
        int c = i % (w * h);
        int z = i / (w * h);
        int y = c / w;
        int x = c % w;
        return vector.set(x, y, z);
    }

    public static float normalizeDegrees(float angle) {
        return MathUtils.normalizeAngle(angle, 180.0f);
    }

    public static float normalizeRadians(float angle) {
        return MathUtils.normalizeAngle(angle, (float)Math.PI);
    }

    private static float normalizeAngle(float angle, float halfCircle) {
        if (Float.isNaN(angle)) {
            angle = 0.0f;
        }
        if ((angle %= halfCircle * 2.0f) > halfCircle) {
            return -halfCircle + (angle - halfCircle);
        }
        return halfCircle + (angle + halfCircle);
    }

    public static float wrapToCircle(float rad) {
        float circle = (float)Math.PI * 2;
        if (rad >= 0.0f) {
            return rad % circle;
        }
        float times = (float)Math.ceil(rad / -circle);
        return rad + circle * times;
    }

    public static boolean isInside(double an, double ax, double bn, double bx) {
        return an < bx && bn < ax;
    }

    public static int remapIndex(int old, int from, int to) {
        if (from == to) {
            return old;
        }
        if (from < to) {
            if (old == from) {
                return to;
            }
            if (old > from && old <= to) {
                return old - 1;
            }
            return old;
        }
        if (old == from) {
            return to;
        }
        if (old >= to && old < from) {
            return old + 1;
        }
        return old;
    }
}

