/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes;

import java.util.Objects;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.utils.interps.Interpolation;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class Keyframe<T>
extends BaseValue {
    private float tick;
    private T value;
    public float lx = 5.0f;
    public float ly;
    public float rx = 5.0f;
    public float ry;
    private float duration;
    private final Interpolation interp = new Interpolation("interp", Interpolations.MAP);
    private final IKeyframeFactory<T> factory;

    public Keyframe(String id, IKeyframeFactory<T> factory, float tick, T value) {
        this(id, factory);
        this.tick = tick;
        this.value = value;
    }

    public Keyframe(String id, IKeyframeFactory<T> factory) {
        super(id);
        this.factory = factory;
    }

    public IKeyframeFactory<T> getFactory() {
        return this.factory;
    }

    public float getTick() {
        return this.tick;
    }

    public void setTick(float tick) {
        this.setTick(tick, false);
    }

    public void setTick(float tick, boolean dirty) {
        if (dirty) {
            this.preNotify();
        }
        this.tick = tick;
        if (dirty) {
            this.postNotify();
        }
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.preNotify();
        this.duration = Math.max(0.0f, duration);
        this.postNotify();
    }

    public T getValue() {
        return this.value;
    }

    public double getY(int index) {
        return this.factory.getY(this.value);
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean dirty) {
        if (dirty) {
            this.preNotify();
        }
        this.value = value;
        if (dirty) {
            this.postNotify();
        }
    }

    public Interpolation getInterpolation() {
        return this.interp;
    }

    public void copy(Keyframe<T> keyframe) {
        this.tick = keyframe.tick;
        this.duration = keyframe.duration;
        this.value = this.factory.copy(keyframe.value);
        this.interp.copy(keyframe.interp);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Keyframe) {
            Keyframe kf = (Keyframe)obj;
            return this.tick == kf.tick && Objects.equals(this.value, kf.value) && this.lx == kf.lx && this.ly == kf.ly && this.rx == kf.rx && this.ry == kf.ry && this.duration == kf.duration && Objects.equals(this.interp, kf.interp);
        }
        return false;
    }

    @Override
    public BaseType toData() {
        MapType data = new MapType();
        data.putFloat("tick", this.tick);
        data.put("value", this.factory.toData(this.value));
        if (this.duration != 0.0f) {
            data.putFloat("duration", this.duration);
        }
        if (this.interp.getInterp() != Interpolations.LINEAR) {
            data.put("interp", this.interp.toData());
        }
        if (this.lx != 5.0f) {
            data.putFloat("lx", this.lx);
        }
        if (this.ly != 0.0f) {
            data.putFloat("ly", this.ly);
        }
        if (this.rx != 5.0f) {
            data.putFloat("rx", this.rx);
        }
        if (this.ry != 0.0f) {
            data.putFloat("ry", this.ry);
        }
        return data;
    }

    @Override
    public void fromData(BaseType data) {
        if (!data.isMap()) {
            return;
        }
        MapType map = data.asMap();
        if (map.has("tick")) {
            this.tick = map.getFloat("tick");
        }
        if (map.has("duration")) {
            this.duration = map.getFloat("duration");
        }
        if (map.has("value")) {
            this.value = this.factory.fromData(map.get("value"));
        }
        if (map.has("interp")) {
            this.interp.fromData(map.get("interp"));
        }
        if (map.has("lx")) {
            this.lx = map.getFloat("lx");
        }
        if (map.has("ly")) {
            this.ly = map.getFloat("ly");
        }
        if (map.has("rx")) {
            this.rx = map.getFloat("rx");
        }
        if (map.has("ry")) {
            this.ry = map.getFloat("ry");
        }
    }
}

