/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes.factories;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.FloatType;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.BezierUtils;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class FloatKeyframeFactory
implements IKeyframeFactory<Float> {
    @Override
    public Float fromData(BaseType data) {
        return Float.valueOf(data.isNumeric() ? data.asNumeric().floatValue() : 0.0f);
    }

    @Override
    public BaseType toData(Float value) {
        return new FloatType(value.floatValue());
    }

    @Override
    public Float createEmpty() {
        return Float.valueOf(0.0f);
    }

    @Override
    public Float copy(Float value) {
        return value;
    }

    @Override
    public Float interpolate(Keyframe<Float> preA, Keyframe<Float> a, Keyframe<Float> b, Keyframe<Float> postB, IInterp interpolation, float x) {
        if (interpolation.has(Interpolations.BEZIER)) {
            return Float.valueOf((float)BezierUtils.get(a.getValue().floatValue(), b.getValue().floatValue(), a.getTick(), b.getTick(), a.rx, a.ry, a.lx, a.ly, x));
        }
        return (Float)((Object)IKeyframeFactory.super.interpolate(preA, a, b, postB, interpolation, x));
    }

    @Override
    public Float interpolate(Float preA, Float a, Float b, Float postB, IInterp interpolation, float x) {
        return Float.valueOf((float)interpolation.interpolate(IInterp.context.set(preA.floatValue(), a.floatValue(), b.floatValue(), postB.floatValue(), x)));
    }

    @Override
    public double getY(Float value) {
        return value.floatValue();
    }

    @Override
    public Object yToValue(double y) {
        return Float.valueOf((float)y);
    }
}

