/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.resources;

import java.io.InputStream;
import java.util.ArrayList;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.FilteredLink;
import mchorse.bbs_mod.utils.resources.MultiLink;
import mchorse.bbs_mod.utils.resources.Pixels;

public class TextureProcessor {
    public static Pixels process(MultiLink multi) {
        ArrayList<Pixels> images = new ArrayList<Pixels>();
        int w = 0;
        int h = 0;
        for (int i = 0; i < multi.children.size(); ++i) {
            FilteredLink child = multi.children.get(i);
            try (InputStream asset = BBSMod.getProvider().getAsset(child.path);){
                Pixels pixels = Pixels.fromPNGStream(asset);
                w = Math.max(w, child.getWidth(pixels.width));
                h = Math.max(h, child.getHeight(pixels.height));
                images.add(pixels);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Pixels output = Pixels.fromSize(w, h);
        for (int i = 0; i < multi.children.size(); ++i) {
            Pixels pixels = (Pixels)images.get(i);
            FilteredLink filter = multi.children.get(i);
            int iw = pixels.width;
            int ih = pixels.height;
            if (filter.scaleToLargest) {
                iw = w;
                ih = h;
            } else if (filter.scale != 0.0f && filter.scale > 0.0f) {
                iw = (int)((float)iw * filter.scale);
                ih = (int)((float)ih * filter.scale);
            }
            if (iw > 0 && ih > 0) {
                if (filter.erase) {
                    TextureProcessor.processErase(output, pixels, filter, iw, ih);
                } else {
                    if (filter.color != -1 || filter.pixelate > 1) {
                        TextureProcessor.processImage(pixels, filter);
                    }
                    output.draw(pixels, filter.shiftX, filter.shiftY, iw, ih);
                }
            }
            pixels.delete();
        }
        output.rewindBuffer();
        return output;
    }

    private static void processErase(Pixels image, Pixels pixels, FilteredLink filter, int iw, int ih) {
        Pixels mask = Pixels.fromSize(image.width, image.height);
        mask.draw(pixels, filter.shiftX, filter.shiftY, iw, ih);
        int c = mask.getCount();
        for (int p = 0; p < c; ++p) {
            Color pixel = mask.getColor(p);
            if (!(pixel.a > 0.999f)) continue;
            pixel = image.getColor(p);
            pixel.a = 0.0f;
            image.setColor(p, pixel);
        }
        mask.delete();
    }

    private static void processImage(Pixels pixels, FilteredLink link) {
        Color filter = new Color().set(link.color);
        Color pixel = new Color();
        int pixelate = link.pixelate;
        int c = pixels.getCount();
        for (int i = 0; i < c; ++i) {
            pixel.copy(pixels.getColor(i));
            if (pixelate > 1) {
                int x = pixels.toX(i);
                int y = pixels.toY(i);
                boolean origin = x % pixelate == 0 && y % pixelate == 0;
                x -= x % pixelate;
                y -= y % pixelate;
                pixel.copy(pixels.getColor(x, y));
                pixels.setColor(i, pixel);
                if (!origin) continue;
            }
            pixel.r *= filter.r;
            pixel.g *= filter.g;
            pixel.b *= filter.b;
            pixel.a *= filter.a;
            pixels.setColor(i, pixel);
        }
    }
}

