/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.forms.CustomVertexConsumerProvider;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.forms.LabelForm;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class LabelFormRenderer
extends FormRenderer<LabelForm> {
    public static void fillQuad(class_287 builder, class_4587 stack, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a) {
        Matrix4f matrix4f = stack.method_23760().method_23761();
        builder.method_22918(matrix4f, x1, y1, z1).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix4f, x2, y2, z2).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix4f, x3, y3, z3).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix4f, x1, y1, z1).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix4f, x3, y3, z3).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix4f, x4, y4, z4).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
    }

    public LabelFormRenderer(LabelForm form) {
        super(form);
    }

    @Override
    public void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        int color = ((Color)((LabelForm)this.form).color.get()).getARGBColor();
        String text = StringUtils.processColoredText((String)((LabelForm)this.form).text.get());
        List<String> wrap = context.batcher.getFont().wrap(text, x2 - x1 - 4);
        int th = context.batcher.getFont().getHeight();
        int lineHeight = th + 4;
        int h = th + (wrap.size() - 1) * lineHeight;
        int y = (y2 + y1) / 2 - h / 2;
        for (String s : wrap) {
            context.batcher.textShadow(s, x1 + 2, y, color);
            y += lineHeight;
        }
    }

    @Override
    public void render3D(FormRenderingContext context) {
        context.stack.method_22903();
        if (((Boolean)((LabelForm)this.form).billboard.get()).booleanValue()) {
            Matrix4f modelMatrix = context.stack.method_23760().method_23761();
            Vector3f scale = Vectors.TEMP_3F;
            modelMatrix.getScale(scale);
            modelMatrix.m00(1.0f).m01(0.0f).m02(0.0f);
            modelMatrix.m10(0.0f).m11(1.0f).m12(0.0f);
            modelMatrix.m20(0.0f).m21(0.0f).m22(1.0f);
            modelMatrix.scale((Vector3fc)scale);
            context.stack.method_23760().method_23762().identity();
        }
        class_327 renderer = class_310.method_1551().field_1772;
        CustomVertexConsumerProvider consumers = FormUtilsClient.getProvider();
        float scale = 0.0625f;
        int light = context.light;
        MatrixStackUtils.scaleStack(context.stack, scale, -scale, scale);
        RenderSystem.disableCull();
        if (context.isPicking()) {
            CustomVertexConsumerProvider.hijackVertexFormat(layer -> {
                this.setupTarget(context, BBSShaders.getPickerModelsProgram());
                RenderSystem.setShader(BBSShaders::getPickerModelsProgram);
            });
            light = 0;
        }
        if ((Integer)((LabelForm)this.form).max.get() <= 10) {
            this.renderString(context, consumers, renderer, light);
        } else {
            this.renderLimitedString(context, consumers, renderer, light);
        }
        CustomVertexConsumerProvider.clearRunnables();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        context.stack.method_22909();
    }

    private void renderString(FormRenderingContext context, CustomVertexConsumerProvider consumers, class_327 renderer, int light) {
        String content = StringUtils.processColoredText((String)((LabelForm)this.form).text.get());
        float transition = context.getTransition();
        int w = renderer.method_1727(content) - 1;
        Objects.requireNonNull(renderer);
        int h = 9 - 2;
        int x = (int)((float)(-w) * ((Float)((LabelForm)this.form).anchorX.get()).floatValue());
        int y = (int)((float)(-h) * ((Float)((LabelForm)this.form).anchorY.get()).floatValue());
        Color shadowColor = ((Color)((LabelForm)this.form).shadowColor.get()).copy();
        Color color = ((Color)((LabelForm)this.form).color.get()).copy();
        color.mul(context.color);
        shadowColor.mul(context.color);
        if (shadowColor.a > 0.0f) {
            context.stack.method_22903();
            context.stack.method_46416(0.0f, 0.0f, -0.1f);
            renderer.method_27521(content, (float)x + ((Float)((LabelForm)this.form).shadowX.get()).floatValue(), (float)y + ((Float)((LabelForm)this.form).shadowY.get()).floatValue(), shadowColor.getARGBColor(), false, context.stack.method_23760().method_23761(), (class_4597)consumers, class_327.class_6415.field_33993, 0, light);
            context.stack.method_22909();
        }
        renderer.method_27521(content, (float)x, (float)y, color.getARGBColor(), false, context.stack.method_23760().method_23761(), (class_4597)consumers, class_327.class_6415.field_33993, 0, light);
        RenderSystem.enableDepthTest();
        consumers.method_22993();
        this.renderShadow(context, x, y, w, h);
    }

    private void renderLimitedString(FormRenderingContext context, CustomVertexConsumerProvider consumers, class_327 renderer, int light) {
        int y;
        float transition = context.getTransition();
        int w = 0;
        Objects.requireNonNull(renderer);
        int h = 9 - 2;
        String content = StringUtils.processColoredText((String)((LabelForm)this.form).text.get());
        List<String> lines = FontRenderer.wrap(renderer, content, (Integer)((LabelForm)this.form).max.get());
        if (lines.size() <= 1) {
            this.renderString(context, consumers, renderer, light);
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            lines.set(i, lines.get(i).trim());
        }
        for (String line : lines) {
            w = Math.max(renderer.method_1727(line) - 1, w);
            h += 12;
        }
        int x = (int)((float)(-w) * ((Float)((LabelForm)this.form).anchorX.get()).floatValue());
        int y2 = y = (int)((float)(-(h -= 12)) * ((Float)((LabelForm)this.form).anchorY.get()).floatValue());
        Color shadowColor = ((Color)((LabelForm)this.form).shadowColor.get()).copy();
        shadowColor.mul(context.color);
        if (shadowColor.a > 0.0f) {
            context.stack.method_22903();
            context.stack.method_46416(0.0f, 0.0f, -0.1f);
            for (String line : lines) {
                int x2 = x + ((Boolean)((LabelForm)this.form).anchorLines.get() != false ? (int)((float)(w - renderer.method_1727(line)) * ((Float)((LabelForm)this.form).anchorX.get()).floatValue()) : 0);
                renderer.method_27521(line, (float)x2 + ((Float)((LabelForm)this.form).shadowX.get()).floatValue(), (float)y2 + ((Float)((LabelForm)this.form).shadowY.get()).floatValue(), shadowColor.getARGBColor(), false, context.stack.method_23760().method_23761(), (class_4597)consumers, class_327.class_6415.field_33993, 0, light);
                y2 += 12;
            }
            context.stack.method_22909();
            y2 = y;
        }
        Color cColor = (Color)((LabelForm)this.form).color.get();
        cColor.mul(context.color);
        int color = cColor.getARGBColor();
        for (String line : lines) {
            int x2 = x + ((Boolean)((LabelForm)this.form).anchorLines.get() != false ? (int)((float)(w - renderer.method_1727(line)) * ((Float)((LabelForm)this.form).anchorX.get()).floatValue()) : 0);
            renderer.method_27521(line, (float)x2, (float)y2, color, false, context.stack.method_23760().method_23761(), (class_4597)consumers, class_327.class_6415.field_33993, 0, light);
            y2 += 12;
        }
        consumers.method_22993();
        RenderSystem.enableDepthTest();
        this.renderShadow(context, x, y, w, h);
    }

    private void renderShadow(FormRenderingContext context, int x, int y, int w, int h) {
        float offset = ((Float)((LabelForm)this.form).offset.get()).floatValue();
        Color color = ((Color)((LabelForm)this.form).background.get()).copy();
        color.mul(context.color);
        if (color.a <= 0.0f) {
            return;
        }
        context.stack.method_22903();
        context.stack.method_46416(0.0f, 0.0f, -0.2f);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_20887);
        LabelFormRenderer.fillQuad(builder, context.stack, (float)(x + w) + offset, (float)y - offset, 0.0f, (float)x - offset, (float)y - offset, 0.0f, (float)x - offset, (float)(y + h) + offset, 0.0f, (float)(x + w) + offset, (float)(y + h) + offset, 0.0f, color.r, color.g, color.b, color.a);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        context.stack.method_22909();
    }
}

