/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.line;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.graphics.line.LinePoint;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2f;
import org.joml.Vector2fc;

@Environment(value=EnvType.CLIENT)
public class Line<T> {
    public List<LinePoint<T>> points = new ArrayList<LinePoint<T>>();

    public Line<T> add(float x, float y) {
        return this.add(x, y, null);
    }

    public Line<T> add(float x, float y, T user) {
        if (!this.points.isEmpty()) {
            LinePoint<T> last = this.points.get(this.points.size() - 1);
            float e = 1.0E-4f;
            if (Math.abs(last.x - x) < 1.0E-4f && Math.abs(last.y - y) < 1.0E-4f) {
                return this;
            }
        }
        this.points.add(new LinePoint<T>(x, y, user));
        return this;
    }

    public List<LinePoint<T>> build(float thickness) {
        ArrayList<LinePoint<T>> compiled = new ArrayList<LinePoint<T>>();
        int c = this.points.size();
        for (int i = 0; i < c; ++i) {
            LinePoint<T> point = this.getPoint(i);
            LinePoint<T> pointPrev = this.getPoint(i - 1);
            LinePoint<T> pointNext = this.getPoint(i + 1);
            LinePoint<T> from = point;
            LinePoint<T> to = point;
            if (pointPrev != null && pointNext != null) {
                Vector2f perpendicularPrev = new Vector2f(pointPrev.x, pointPrev.y).sub(point.x, point.y).perpendicular().normalize().mul(thickness);
                Vector2f perpendicularNext = new Vector2f(point.x, point.y).sub(pointNext.x, pointNext.y).perpendicular().normalize().mul(thickness);
                compiled.add(new LinePoint(-perpendicularPrev.x + point.x, -perpendicularPrev.y + point.y, point.user));
                compiled.add(new LinePoint(perpendicularPrev.x + point.x, perpendicularPrev.y + point.y, point.user));
                compiled.add(new LinePoint(-perpendicularNext.x + point.x, -perpendicularNext.y + point.y, point.user));
                compiled.add(new LinePoint(perpendicularNext.x + point.x, perpendicularNext.y + point.y, point.user));
                continue;
            }
            if (pointPrev != null) {
                from = pointPrev;
                to = point;
            } else if (pointNext != null) {
                to = pointNext;
            }
            Vector2f perpendicular = new Vector2f(from.x, from.y).sub(to.x, to.y).perpendicular().normalize().mul(thickness);
            compiled.add(new LinePoint(-perpendicular.x + point.x, -perpendicular.y + point.y, point.user));
            compiled.add(new LinePoint(perpendicular.x + point.x, perpendicular.y + point.y, point.user));
        }
        return compiled;
    }

    private Vector2f getClosest(Vector2f a, Vector2f b, Vector2f ref) {
        return ref.distanceSquared((Vector2fc)a) < ref.distanceSquared((Vector2fc)b) ? a : b;
    }

    private Vector2f getFurthest(Vector2f a, Vector2f b, Vector2f ref) {
        return ref.distanceSquared((Vector2fc)a) > ref.distanceSquared((Vector2fc)b) ? a : b;
    }

    private LinePoint<T> getPoint(int i) {
        if (i < 0 || i >= this.points.size()) {
            return null;
        }
        return this.points.get(i);
    }
}

