/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.line;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.graphics.line.ILineRenderer;
import mchorse.bbs_mod.graphics.line.Line;
import mchorse.bbs_mod.graphics.line.LinePoint;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class LineBuilder<T> {
    public float thickness;
    public List<Line<T>> lines = new ArrayList<Line<T>>();

    public LineBuilder(float thickness) {
        this.thickness = thickness;
    }

    public LineBuilder<T> add(float x, float y) {
        return this.add(x, y, null);
    }

    public LineBuilder<T> add(float x, float y, T user) {
        if (this.lines.isEmpty()) {
            this.push();
        }
        Line<T> line = this.lines.get(this.lines.size() - 1);
        line.add(x, y, user);
        return this;
    }

    public LineBuilder<T> push() {
        return this.push(new Line());
    }

    public LineBuilder<T> push(Line<T> line) {
        this.lines.add(line);
        return this;
    }

    public List<List<LinePoint<T>>> build() {
        ArrayList<List<LinePoint<T>>> output = new ArrayList<List<LinePoint<T>>>();
        for (Line<T> line : this.lines) {
            List<LinePoint<T>> compiled = line.build(this.thickness);
            if (compiled.isEmpty()) continue;
            output.add(compiled);
        }
        return output;
    }

    public void render(Batcher2D batcher2D, ILineRenderer<T> renderer) {
        Matrix4f matrix = batcher2D.getContext().method_51448().method_23760().method_23761();
        List<List<LinePoint<T>>> build = this.build();
        for (List<LinePoint<T>> points : build) {
            class_287 builder = class_289.method_1348().method_1349();
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.enableBlend();
            builder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (LinePoint<T> point : points) {
                renderer.render(builder, matrix, point);
            }
            class_286.method_43433((class_287.class_7433)builder.method_1326());
        }
    }
}

