/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.settings.values.numeric;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.FloatType;
import mchorse.bbs_mod.settings.values.base.BaseValueNumber;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class ValueFloat
extends BaseValueNumber<Float> {
    public ValueFloat(String id, Float defaultValue) {
        this(id, defaultValue, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public ValueFloat(String id, Float defaultValue, Float min, Float max) {
        super(id, KeyframeFactories.FLOAT, defaultValue, min, max);
    }

    @Override
    protected Float clamp(Float value) {
        return Float.valueOf(MathUtils.clamp(value.floatValue(), ((Float)this.min).floatValue(), ((Float)this.max).floatValue()));
    }

    @Override
    public BaseType toData() {
        return new FloatType(((Float)this.value).floatValue());
    }

    @Override
    public void fromData(BaseType data) {
        if (data.isNumeric()) {
            this.value = Float.valueOf(data.asNumeric().floatValue());
        }
    }

    public String toString() {
        return Float.toString(((Float)this.value).floatValue());
    }
}

