/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.controller;

import java.util.Map;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.controller.ICameraController;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.film.controller.UIFilmController;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.keys.KeyAction;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Intersectionf;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

@Environment(value=EnvType.CLIENT)
public class OrbitFilmCameraController
implements ICameraController {
    private UIFilmController controller;
    public boolean enabled;
    private boolean orbiting;
    private Vector2f rotation = new Vector2f();
    private Vector2i last = new Vector2i();
    private Vector3f position = new Vector3f();
    private float distance;
    private float offsetY;
    private boolean center;
    protected Vector3i velocityPosition = new Vector3i();

    public OrbitFilmCameraController(UIFilmController controller) {
        this.controller = controller;
    }

    public void start(UIContext context) {
        if (context.mouseButton != 2) {
            return;
        }
        this.center = Window.isKeyPressed(Keys.FLIGHT_ORBIT.getMainKey());
        this.orbiting = true;
        this.last.set(context.mouseX, context.mouseY);
        if (this.center) {
            Vector3f rayDirection = this.rotateVector(0.0f, 0.0f, -1.0f, this.rotation.y, this.rotation.x, false);
            Vector3f normal = Vectors.TEMP_3F.set((Vector3fc)rayDirection).mul(-1.0f, 0.0f, -1.0f).normalize();
            float t = Intersectionf.intersectRayPlane((Vector3fc)this.position, (Vector3fc)rayDirection, (Vector3fc)new Vector3f(0.0f, this.offsetY, 0.0f), (Vector3fc)normal, (float)1.0E-4f);
            Vector3f p = new Vector3f((Vector3fc)rayDirection).mul(t).add((Vector3fc)this.position);
            p.x = 0.0f;
            p.z = 0.0f;
            this.distance = this.position.distance((Vector3fc)p);
            this.offsetY = p.y;
        }
    }

    public void stop() {
        if (this.center) {
            this.position.set((Vector3fc)this.rotateVector(0.0f, 0.0f, 1.0f, this.rotation.y, this.rotation.x, false).mul(this.distance));
            this.position.add(0.0f, this.offsetY, 0.0f);
        }
        this.orbiting = false;
        this.center = false;
    }

    public boolean keyPressed(UIContext context, Area area) {
        if (!this.enabled || context.isFocused()) {
            return false;
        }
        if (area.isInside(context) || !this.velocityPosition.equals(0, 0, 0) && context.getKeyAction() == KeyAction.RELEASED) {
            int x = this.getFactor(context, Keys.FLIGHT_LEFT, Keys.FLIGHT_RIGHT, this.velocityPosition.x);
            int y = this.getFactor(context, Keys.FLIGHT_UP, Keys.FLIGHT_DOWN, this.velocityPosition.y);
            int z = this.getFactor(context, Keys.FLIGHT_FORWARD, Keys.FLIGHT_BACKWARD, this.velocityPosition.z);
            boolean changed = x != this.velocityPosition.x || y != this.velocityPosition.y || z != this.velocityPosition.z;
            this.velocityPosition.set(x, y, z);
            return changed;
        }
        return false;
    }

    protected int getFactor(UIContext context, KeyCombo positive, KeyCombo negative, int x) {
        if (context.isPressed(positive.getMainKey())) {
            return 1;
        }
        if (context.isPressed(negative.getMainKey())) {
            return -1;
        }
        if (context.isReleased(positive.getMainKey()) && x > 0 || context.isReleased(negative.getMainKey()) && x < 0) {
            return 0;
        }
        return x;
    }

    public void handleOrbiting(UIContext context) {
        if (this.orbiting) {
            int x = context.mouseX;
            int y = context.mouseY;
            this.rotation.add((float)(-(y - this.last.y)) * this.controller.panel.dashboard.orbit.getAngleSpeed(), (float)(-(x - this.last.x)) * this.controller.panel.dashboard.orbit.getAngleSpeed());
            this.last.set(x, y);
        }
    }

    public boolean update(UIContext context) {
        if (!this.enabled || context.isFocused()) {
            return false;
        }
        boolean changed = false;
        if (this.velocityPosition.lengthSquared() > 0L && !this.center) {
            this.position.add((Vector3fc)this.rotateVector(-this.velocityPosition.x, this.velocityPosition.y, -this.velocityPosition.z, this.rotation.y, this.rotation.x).mul(this.getSpeed()));
            changed = true;
        } else if (this.center) {
            this.position.set((Vector3fc)this.rotateVector(0.0f, 0.0f, 1.0f, this.rotation.y, this.rotation.x).mul(this.distance));
            this.position.add(0.0f, this.offsetY, 0.0f);
        }
        return changed;
    }

    protected float getSpeed() {
        return this.controller.panel.dashboard.orbit.getSpeed();
    }

    protected Vector3f rotateVector(float x, float y, float z, float yaw, float pitch) {
        return this.rotateVector(x, y, z, yaw, pitch, (Boolean)BBSSettings.editorHorizontalFlight.get());
    }

    protected Vector3f rotateVector(float x, float y, float z, float yaw, float pitch, boolean horizontal) {
        Matrix3f rotation = new Matrix3f();
        Vector3f rotate = new Vector3f(x, y, z);
        rotation.rotateY(yaw);
        if (!horizontal) {
            rotation.rotateX(pitch);
        }
        rotation.transform(rotate);
        return rotate;
    }

    @Override
    public void setup(Camera camera, float transition) {
        IEntity entity = this.controller.getCurrentEntity();
        if (entity != null) {
            float renderYaw = MathUtils.toRad(-Lerps.lerp(entity.getPrevBodyYaw(), entity.getBodyYaw(), transition) + 180.0f);
            Vector3f offset = this.rotateVector(this.position.x, this.position.y, this.position.z, renderYaw, 0.0f);
            if (this.center) {
                offset = this.rotateVector(0.0f, 0.0f, 1.0f, this.rotation.y + renderYaw, this.rotation.x, false).mul(this.distance);
                offset.add(0.0f, this.offsetY, 0.0f);
            }
            Form form = entity.getForm();
            double h = entity.getPickingHitbox().h / 2.0;
            double x = Lerps.lerp(entity.getPrevX(), entity.getX(), (double)transition);
            double y = Lerps.lerp(entity.getPrevY(), entity.getY(), (double)transition) + h;
            double z = Lerps.lerp(entity.getPrevZ(), entity.getZ(), (double)transition);
            if (form != null) {
                Matrix4f anchor;
                ModelForm modelForm;
                ModelInstance model;
                Map<String, Matrix4f> map = FormUtilsClient.getRenderer(form).collectMatrices(entity, "", transition);
                String group = "anchor";
                if (form instanceof ModelForm && (model = ModelFormRenderer.getModel(modelForm = (ModelForm)form)) != null) {
                    String anchor2 = model.getAnchor();
                    String string = group = anchor2.isEmpty() ? group : anchor2;
                }
                if ((anchor = map.get(group)) != null) {
                    Anchor v = (Anchor)form.anchor.get();
                    Matrix4f defaultMatrix = BaseFilmController.getMatrixForRenderWithRotation(entity, x, y, z, transition);
                    Pair<Matrix4f, Float> totalMatrix = BaseFilmController.getTotalMatrix(this.controller.getEntities(), v, defaultMatrix, x, y, z, transition, 0);
                    if (totalMatrix.a != null) {
                        defaultMatrix = (Matrix4f)totalMatrix.a;
                    }
                    defaultMatrix.mul((Matrix4fc)anchor);
                    Vector3f translate = defaultMatrix.getTranslation(Vectors.TEMP_3F);
                    x += (double)translate.x;
                    y += (double)translate.y;
                    z += (double)translate.z;
                }
            }
            camera.position.set(x, y, z);
            camera.position.add((Vector3fc)offset);
            camera.rotation.set(-this.rotation.x, -(this.rotation.y + renderYaw), 0.0f);
        }
    }

    @Override
    public int getPriority() {
        return 20;
    }

    public void reset() {
        this.position.set(0.0f, 0.0f, -4.0f);
        this.rotation.set(0.0, Math.PI);
    }
}

