/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.utils.UIRenderable;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.resizers.Flex;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIPanelBase<T extends UIElement>
extends UIElement {
    public T view;
    public UIScrollView buttons;
    public List<T> panels = new ArrayList<T>();
    public Direction direction;

    public UIPanelBase() {
        this(Direction.BOTTOM);
    }

    public UIPanelBase(Direction direction) {
        this.direction = direction == null ? Direction.BOTTOM : direction;
        this.buttons = new UIScrollView();
        this.buttons.scroll.cancelScrolling().noScrollbar();
        this.buttons.scroll.scrollSpeed = 5;
        this.buttons.preRender(context -> {
            int c = this.panels.size();
            for (int i = 0; i < c; ++i) {
                if (this.view != this.panels.get(i)) continue;
                Area area = ((UIIcon)this.buttons.getChildren().get((int)i)).area;
                area.render(context.batcher, 0xBB000000 | (Integer)BBSSettings.primaryColor.get());
            }
        });
        this.setButtonsPlacement();
        this.add(new UIRenderable(this::renderOverlay), this.buttons);
    }

    public void changeDirection(Direction direction) {
        this.direction = direction == null ? Direction.BOTTOM : direction;
        this.setButtonsPlacement();
        if (this.view != null) {
            this.setPanelPlacement((UIElement)this.view);
        }
        for (UIElement element : this.buttons.getChildren(UIElement.class)) {
            if (element.tooltip == null) continue;
            element.tooltip(element.tooltip.getLabel(), this.direction.opposite());
        }
        this.resize();
    }

    private void setButtonsPlacement() {
        this.buttons.scroll.direction = this.direction.factorX == 0 ? ScrollDirection.HORIZONTAL : ScrollDirection.VERTICAL;
        this.buttons.resetFlex();
        if (this.direction == Direction.TOP) {
            this.buttons.relative(this).w(1.0f).h(20).column(0).scroll();
        } else if (this.direction == Direction.LEFT) {
            this.buttons.relative(this).w(20).h(1.0f).column(0).scroll().vertical();
        } else if (this.direction == Direction.BOTTOM) {
            this.buttons.relative(this).y(1.0f, -20).w(1.0f).h(20).column(0).scroll();
        } else {
            this.buttons.relative(this).x(1.0f, -20).w(20).h(1.0f).column(0).scroll().vertical();
        }
    }

    private void setPanelPlacement(UIElement panel) {
        Flex flex = panel.getFlex();
        flex.relative = null;
        flex.x.reset();
        flex.y.reset();
        flex.w.reset();
        flex.h.reset();
        if (this.direction == Direction.TOP) {
            panel.relative(this).y(20).w(1.0f).h(1.0f, -20);
        } else if (this.direction == Direction.LEFT) {
            panel.relative(this).x(20).w(1.0f, -20).h(1.0f);
        } else if (this.direction == Direction.RIGHT) {
            panel.relative(this).w(1.0f, -20).h(1.0f);
        } else {
            panel.relative(this).w(1.0f).h(1.0f, -20);
        }
    }

    public UIIcon getButton(T panel) {
        int index = this.panels.indexOf(panel);
        return index < 0 ? null : (UIIcon)this.buttons.getChildren().get(index);
    }

    public UIIcon registerPanel(T panel, IKey tooltip, Icon icon) {
        UIIcon button = new UIIcon(icon, b -> this.setPanel(panel));
        if (tooltip != null && !tooltip.get().isEmpty()) {
            button.tooltip(tooltip, this.direction.opposite());
        }
        ((UIElement)panel).markContainer();
        this.panels.add(panel);
        this.buttons.add((IUIElement)button);
        return button;
    }

    public void setPanel(T panel) {
        if (this.view != null) {
            ((UIElement)this.view).removeFromParent();
        }
        this.view = panel;
        if (this.view != null) {
            this.setPanelPlacement((UIElement)panel);
            ((UIElement)this.view).resize();
            this.prepend((IUIElement)this.view);
        }
    }

    protected void renderOverlay(UIContext context) {
        if (this.direction == Direction.TOP) {
            this.renderBackground(context, this.area.x, this.area.y, this.area.w, 20);
        } else if (this.direction == Direction.BOTTOM) {
            this.renderBackground(context, this.area.x, this.area.ey() - 20, this.area.w, 20);
        } else if (this.direction == Direction.LEFT) {
            this.renderBackground(context, this.area.x, this.area.y, 20, this.area.h);
        } else {
            this.renderBackground(context, this.area.ex() - 20, this.area.y, 20, this.area.h);
        }
    }

    protected void renderBackground(UIContext context, int x, int y, int w, int h) {
    }
}

