/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.list;

import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.utils.Label;
import mchorse.bbs_mod.utils.NaturalOrderComparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UILabelList<T>
extends UIList<Label<T>> {
    public UILabelList(Consumer<List<Label<T>>> callback) {
        super(callback);
        this.scroll.scrollItemSize = 16;
    }

    public void add(IKey title, T value) {
        this.add(new Label<T>(title, value));
    }

    public void setCurrentTitle(String title) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((Label)this.list.get((int)i)).title.equals(title)) continue;
            this.setIndex(i);
            return;
        }
    }

    public void setCurrentValue(T value) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((Label)this.list.get((int)i)).value.equals(value)) continue;
            this.setIndex(i);
            return;
        }
    }

    @Override
    protected boolean sortElements() {
        this.list.sort((a, b) -> NaturalOrderComparator.compare(true, a.title.get(), b.title.get()));
        return true;
    }

    @Override
    protected String elementToString(UIContext context, int i, Label<T> element) {
        return element.title.get();
    }
}

