/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeComponentSection;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIParticleSchemeModeSection<T extends ParticleComponentBase>
extends UIParticleSchemeComponentSection<T> {
    public UICirculate mode = new UICirculate(b -> this.updateMode(this.mode.getValue()));
    public UILabel modeLabel;

    public UIParticleSchemeModeSection(UIParticleSchemePanel parent) {
        super(parent);
        this.fillModes(this.mode);
        this.modeLabel = UI.label(UIKeys.SNOWSTORM_MODE, 20).labelAnchor(0.0f, 0.5f);
        this.fields.add((IUIElement)UI.row(5, 0, 20, this.modeLabel, this.mode));
    }

    @Override
    protected T getComponent(ParticleScheme scheme) {
        return scheme.getOrCreate(this.getBaseClass(), this.getDefaultClass());
    }

    @Override
    protected void fillData() {
        super.fillData();
        int c = this.mode.getLabels().size();
        for (int i = 0; i < c; ++i) {
            if (this.getModeClass(i) != this.component.getClass()) continue;
            this.mode.setValue(i);
            break;
        }
    }

    protected abstract void fillModes(UICirculate var1);

    protected void updateMode(int value) {
        ParticleComponentBase old = this.component;
        this.component = this.scheme.replace(this.getBaseClass(), this.getModeClass(this.mode.getValue()));
        this.restoreInfo(this.component, old);
        this.editor.dirty();
        this.fillData();
    }

    protected void restoreInfo(T component, T old) {
    }

    protected abstract Class<T> getBaseClass();

    protected abstract Class getDefaultClass();

    protected abstract Class getModeClass(int var1);
}

