/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes.factories;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.DoubleType;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.BezierUtils;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class DoubleKeyframeFactory
implements IKeyframeFactory<Double> {
    @Override
    public Double fromData(BaseType data) {
        return data.isNumeric() ? data.asNumeric().doubleValue() : 0.0;
    }

    @Override
    public BaseType toData(Double value) {
        return new DoubleType(value);
    }

    @Override
    public Double createEmpty() {
        return 0.0;
    }

    @Override
    public Double copy(Double value) {
        return value;
    }

    @Override
    public Double interpolate(Keyframe<Double> preA, Keyframe<Double> a, Keyframe<Double> b, Keyframe<Double> postB, IInterp interpolation, float x) {
        if (interpolation.has(Interpolations.BEZIER)) {
            return BezierUtils.get(a.getValue(), b.getValue(), a.getTick(), b.getTick(), a.rx, a.ry, b.lx, b.ly, x);
        }
        return (Double)((Object)IKeyframeFactory.super.interpolate(preA, a, b, postB, interpolation, x));
    }

    @Override
    public Double interpolate(Double preA, Double a, Double b, Double postB, IInterp interpolation, float x) {
        return interpolation.interpolate(IInterp.context.set(preA, a, b, postB, x));
    }

    @Override
    public double getY(Double value) {
        return value;
    }

    @Override
    public Object yToValue(double y) {
        return y;
    }
}

