/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mchorse.bbs_mod.resources.ISourcePack;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.StringUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class MinecraftSourcePack
implements ISourcePack {
    private final class_3300 manager;
    private Map<String, Object> links = new HashMap<String, Object>();

    public MinecraftSourcePack() {
        this.manager = class_310.method_1551().method_1478();
        this.setupPaths();
    }

    public void setupPaths() {
        Map map = this.manager.method_41265("textures", l -> l.method_12836().equals("minecraft") && l.method_12832().endsWith(".png"));
        for (class_2960 id : map.keySet()) {
            DataPath path = new DataPath(id.method_12832());
            this.insert(path);
        }
    }

    private void insert(DataPath path) {
        Map links = this.links;
        for (String string : path.strings) {
            if (string.endsWith(".png")) {
                links.put((String)string, (Object)string);
                return;
            }
            if (!links.containsKey(string)) {
                links.put(string, new HashMap());
            }
            links = (Map)links.get(string);
        }
    }

    @Override
    public String getPrefix() {
        return "minecraft";
    }

    @Override
    public boolean hasAsset(Link link) {
        return this.manager.method_14486(new class_2960(link.toString())).isPresent();
    }

    @Override
    public InputStream getAsset(Link link) throws IOException {
        Optional resource = this.manager.method_14486(new class_2960(link.toString()));
        if (resource.isPresent()) {
            return ((class_3298)resource.get()).method_14482();
        }
        return null;
    }

    @Override
    public File getFile(Link link) {
        return null;
    }

    @Override
    public Link getLink(File file) {
        return null;
    }

    @Override
    public void getLinksFromPath(Collection<Link> links, Link link, boolean recursive) {
        String path = link.path.endsWith("/") ? link.path.substring(0, link.path.length() - 1) : link.path;
        Map<String, Object> allLinks = this.findBasePath(path);
        if (allLinks != null) {
            this.traverse(links, path, allLinks, recursive);
        }
    }

    private Map<String, Object> findBasePath(String path) {
        if (path.isEmpty()) {
            return this.links;
        }
        DataPath dataPath = new DataPath(path);
        Map map = this.links;
        for (String next : dataPath.strings) {
            Object o = map.get(next);
            if (o instanceof Map) {
                map = (Map)o;
                continue;
            }
            return null;
        }
        return map;
    }

    private void traverse(Collection<Link> links, String path, Map<String, Object> allLinks, boolean recursive) {
        for (Map.Entry<String, Object> entry : allLinks.entrySet()) {
            if (entry.getValue() instanceof Map) {
                if (recursive) {
                    this.traverse(links, StringUtils.combinePaths(path, entry.getKey()), (Map)entry.getValue(), recursive);
                }
                links.add(new Link(this.getPrefix(), StringUtils.combinePaths(path, entry.getKey()) + "/"));
                continue;
            }
            links.add(new Link(this.getPrefix(), StringUtils.combinePaths(path, entry.getKey())));
        }
    }
}

