/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.fluidvoidfading;

import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="fluidvoidfading", dist={Dist.CLIENT})
public class FluidVoidFading {
    public static final String MODID = "fluidvoidfading";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fluidvoidfading");
    private static final ModConfigSpec SPEC;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> TRANSPARENT_FLUIDS;

    public FluidVoidFading(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC);
        bus.addListener(FluidVoidFading::clientStartup);
    }

    public static void clientStartup(FMLClientSetupEvent event) {
        for (String s : (List)TRANSPARENT_FLUIDS.get()) {
            ResourceLocation rl = ResourceLocation.parse((String)s);
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getValue(rl);
            if (fluid == Fluids.EMPTY) {
                LOGGER.error("Fluid '{}' not found!", (Object)s);
                continue;
            }
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        TRANSPARENT_FLUIDS = builder.comment("If you notice a fluid not rendering transparent, try adding its identifier here").defineListAllowEmpty("additionalTransparentFluids", List.of("minecraft:flowing_lava"), () -> "", o -> {
            if (o instanceof String) {
                try {
                    ResourceLocation.parse((String)((String)o));
                    return true;
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            }
            return false;
        });
        SPEC = builder.build();
    }
}

