/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.fluidvoidfading.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LiquidBlockRenderer.class})
public abstract class LiquidBlockRendererMixin {
    @Shadow
    private TextureAtlasSprite waterOverlay;

    @Shadow
    private static boolean isNeighborSameFluid(FluidState firstState, FluidState secondState) {
        throw new AssertionError();
    }

    @Shadow
    protected abstract int getLightColor(BlockAndTintGetter var1, BlockPos var2);

    @Inject(method={"tesselate"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;isNeighborStateHidingOverlay(Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z")})
    public void render(BlockAndTintGetter level, BlockPos pos, VertexConsumer consumer, BlockState blockState, FluidState fluidState, CallbackInfo ci, @Local(ordinal=0) int color, @Local TextureAtlasSprite[] sprites, @Local(ordinal=3) FluidState north, @Local(ordinal=4) FluidState south, @Local(ordinal=5) FluidState west, @Local(ordinal=6) FluidState east) {
        if (pos.getY() != level.getMinY()) {
            return;
        }
        Fluid fluid = fluidState.getType();
        if (fluid != Fluids.EMPTY) {
            float brightnessUp = level.getShade(Direction.UP, true);
            float brightnessNorth = level.getShade(Direction.NORTH, true);
            float brightnessWest = level.getShade(Direction.WEST, true);
            float xLo = pos.getX() & 0xF;
            float yLo = pos.getY() & 0xF;
            float zLo = pos.getZ() & 0xF;
            int light = this.getLightColor(level, pos);
            TextureAtlasSprite sprite = sprites[1];
            float u1 = sprite.getU(0.0f);
            float u2 = sprite.getU(0.5f);
            float v1 = sprite.getV(0.0f);
            float v2 = sprite.getV(0.5f);
            int[] colors = LiquidBlockRendererMixin.unpackColor(color);
            float redF = (float)colors[1] / 255.0f;
            float greenF = (float)colors[2] / 255.0f;
            float blueF = (float)colors[3] / 255.0f;
            float alpha1 = (float)colors[0] / 255.0f;
            float alpha2 = 0.3f * alpha1;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                boolean shouldRender;
                float z2;
                float z1;
                float x2;
                float x1;
                if (dir == Direction.NORTH) {
                    x1 = xLo;
                    x2 = xLo + 1.0f;
                    z1 = zLo + 0.001f;
                    z2 = zLo + 0.001f;
                    shouldRender = LiquidBlockRendererMixin.isNeighborSameFluid(fluidState, north);
                } else if (dir == Direction.SOUTH) {
                    x1 = xLo + 1.0f;
                    x2 = xLo;
                    z1 = zLo + 0.999f;
                    z2 = zLo + 0.999f;
                    shouldRender = LiquidBlockRendererMixin.isNeighborSameFluid(fluidState, south);
                } else if (dir == Direction.WEST) {
                    x1 = xLo + 0.001f;
                    x2 = xLo + 0.001f;
                    z1 = zLo + 1.0f;
                    z2 = zLo;
                    shouldRender = LiquidBlockRendererMixin.isNeighborSameFluid(fluidState, west);
                } else {
                    if (dir != Direction.EAST) continue;
                    x1 = xLo + 0.999f;
                    x2 = xLo + 0.999f;
                    z1 = zLo;
                    z2 = zLo + 1.0f;
                    shouldRender = LiquidBlockRendererMixin.isNeighborSameFluid(fluidState, east);
                }
                if (shouldRender) continue;
                float sidedBrightness = dir.getAxis() == Direction.Axis.Z ? brightnessNorth : brightnessWest;
                float red = brightnessUp * sidedBrightness * redF;
                float green = brightnessUp * sidedBrightness * greenF;
                float blue = brightnessUp * sidedBrightness * blueF;
                this.fluidvoidfading$vertex(consumer, x1, yLo + 0.0f, z1, red, green, blue, u1, v1, light, alpha1);
                this.fluidvoidfading$vertex(consumer, x2, yLo + 0.0f, z2, red, green, blue, u2, v1, light, alpha1);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 1.0f, z2, red, green, blue, u2, v2, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x1, yLo - 1.0f, z1, red, green, blue, u1, v2, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x1, yLo - 1.0f, z1, red, green, blue, u1, v1, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 1.0f, z2, red, green, blue, u2, v1, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 2.0f, z2, red, green, blue, u2, v2, light, 0.0f);
                this.fluidvoidfading$vertex(consumer, x1, yLo - 2.0f, z1, red, green, blue, u1, v2, light, 0.0f);
                if (sprite == this.waterOverlay) continue;
                this.fluidvoidfading$vertex(consumer, x1, yLo - 1.0f, z1, red, green, blue, u1, v2, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 1.0f, z2, red, green, blue, u2, v2, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x2, yLo + 0.0f, z2, red, green, blue, u2, v1, light, alpha1);
                this.fluidvoidfading$vertex(consumer, x1, yLo + 0.0f, z1, red, green, blue, u1, v1, light, alpha1);
                this.fluidvoidfading$vertex(consumer, x1, yLo - 2.0f, z1, red, green, blue, u1, v2, light, 0.0f);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 2.0f, z2, red, green, blue, u2, v2, light, 0.0f);
                this.fluidvoidfading$vertex(consumer, x2, yLo - 1.0f, z2, red, green, blue, u2, v1, light, alpha2);
                this.fluidvoidfading$vertex(consumer, x1, yLo - 1.0f, z1, red, green, blue, u1, v1, light, alpha2);
            }
        }
    }

    @Unique
    private static int[] unpackColor(int color) {
        int[] colors = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    @Unique
    private void fluidvoidfading$vertex(VertexConsumer vertexConsumer, float x, float y, float z, float red, float green, float blue, float u, float v, int light, float alpha) {
        vertexConsumer.addVertex(x, y, z).setColor(red, green, blue, alpha).setUv(u, v).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }
}

