/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.fluidvoidfading.mixin.client;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadViewMutable;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.DefaultFluidRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.services.PlatformBlockAccess;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(value={DefaultFluidRenderer.class}, remap=false)
public abstract class SodiumDefaultFluidRendererMixin {
    @Shadow
    @Final
    private BlockPos.MutableBlockPos scratchPos;
    @Shadow
    @Final
    private ModelQuadViewMutable quad;
    @Shadow
    @Final
    private int[] quadColors;
    @Shadow
    @Final
    private LightPipelineProvider lighters;
    @Shadow
    @Final
    private float[] brightness;
    @Shadow
    @Final
    private QuadLightData quadLightData;
    @Shadow
    @Final
    public static float EPSILON;

    @Shadow
    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
    }

    @Shadow
    protected abstract void writeQuad(ChunkModelBuilder var1, TranslucentGeometryCollector var2, Material var3, BlockPos var4, ModelQuadView var5, ModelQuadFacing var6, boolean var7);

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void render(LevelSlice level, BlockState blockState, FluidState fluidState, BlockPos blockPos, BlockPos offset, TranslucentGeometryCollector collector, ChunkModelBuilder meshBuilder, Material material, ColorProvider<FluidState> colorProvider, TextureAtlasSprite[] sprites, CallbackInfo ci) {
        if (blockPos.getY() != level.getMinY()) {
            return;
        }
        boolean isWater = fluidState.is(FluidTags.WATER);
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && Minecraft.useAmbientOcclusion() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(6);
        for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            float z2;
            float z1;
            float x2;
            float x1;
            BlockState adjBlock = level.getBlockState((BlockPos)this.scratchPos.setWithOffset((Vec3i)blockPos, dir));
            if (!adjBlock.getFluidState().isEmpty()) continue;
            if (dir == Direction.NORTH) {
                x1 = 0.0f;
                x2 = 1.0f;
                z2 = z1 = EPSILON;
            } else if (dir == Direction.SOUTH) {
                x1 = 1.0f;
                x2 = 0.0f;
                z2 = z1 = 1.0f - EPSILON;
            } else if (dir == Direction.WEST) {
                x2 = x1 = EPSILON;
                z1 = 1.0f;
                z2 = 0.0f;
            } else {
                if (dir != Direction.EAST) continue;
                x2 = x1 = 1.0f - EPSILON;
                z1 = 0.0f;
                z2 = 1.0f;
            }
            TextureAtlasSprite sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && sprites[2] != null && PlatformBlockAccess.getInstance().shouldShowFluidOverlay(adjBlock, (BlockAndTintGetter)level, (BlockPos)this.scratchPos, fluidState)) {
                sprite = sprites[2];
                isOverlay = true;
            }
            float u1 = sprite.getU(0.0f);
            float u2 = sprite.getU(0.5f);
            float v1 = sprite.getV(0.0f);
            float v2 = sprite.getV(0.5f);
            quad.setSprite(sprite);
            SodiumDefaultFluidRendererMixin.setVertex(quad, 0, x2, 1.0f, z2, u2, v1);
            SodiumDefaultFluidRendererMixin.setVertex(quad, 1, x2, EPSILON, z2, u2, v2);
            SodiumDefaultFluidRendererMixin.setVertex(quad, 2, x1, EPSILON, z1, u1, v2);
            SodiumDefaultFluidRendererMixin.setVertex(quad, 3, x1, 1.0f, z1, u1, v1);
            float br = dir.getAxis() == Direction.Axis.Z ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection((Direction)dir);
            lighter.calculate((ModelQuadView)quad, blockPos, this.quadLightData, null, dir, false, false);
            colorProvider.getColors(level, blockPos, this.scratchPos, (Object)fluidState, (ModelQuadView)quad, this.quadColors, level.hasBiomeBlend());
            int[] original = new int[]{ColorARGB.toABGR((int)this.quadColors[0]), ColorARGB.toABGR((int)this.quadColors[1]), ColorARGB.toABGR((int)this.quadColors[2]), ColorARGB.toABGR((int)this.quadColors[3])};
            BlockPos downPos1 = offset.below(1);
            this.fluidvoidfading$updateQuadWithAlpha(quad, facing, br, original, 1.0f, 0.3f);
            this.writeQuad(meshBuilder, collector, material, downPos1, (ModelQuadView)quad, facing, false);
            if (!isOverlay) {
                this.writeQuad(meshBuilder, collector, material, downPos1, (ModelQuadView)quad, facing.getOpposite(), true);
            }
            BlockPos downPos2 = offset.below(2);
            this.fluidvoidfading$updateQuadWithAlpha(quad, facing, br, original, 0.3f, 0.0f);
            this.writeQuad(meshBuilder, collector, material, downPos2, (ModelQuadView)quad, facing, false);
            if (isOverlay) continue;
            this.writeQuad(meshBuilder, collector, material, downPos2, (ModelQuadView)quad, facing.getOpposite(), true);
        }
    }

    @Inject(method={"isSideExposed"}, at={@At(value="HEAD")}, cancellable=true)
    private void fluidVoidFading$isSideExposed(BlockAndTintGetter world, int x, int y, int z, Direction dir, float height, CallbackInfoReturnable<Boolean> cir) {
        if (dir == Direction.DOWN && y == world.getMinY()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private void fluidvoidfading$updateQuadWithAlpha(ModelQuadViewMutable quad, ModelQuadFacing facing, float brightness, int[] originalColors, float alphaStart, float alphaEnd) {
        quad.setFaceNormal(facing.isAligned() ? facing.getPackedAlignedNormal() : quad.calculateNormal());
        int original = originalColors[0];
        this.quadColors[0] = ColorABGR.withAlpha((int)original, (float)(alphaStart * ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackAlpha((int)original))));
        this.brightness[0] = this.quadLightData.br[0] * brightness;
        original = originalColors[1];
        this.quadColors[1] = ColorABGR.withAlpha((int)original, (float)(alphaEnd * ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackAlpha((int)original))));
        this.brightness[1] = this.quadLightData.br[1] * brightness;
        original = originalColors[2];
        this.quadColors[2] = ColorABGR.withAlpha((int)original, (float)(alphaEnd * ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackAlpha((int)original))));
        this.brightness[2] = this.quadLightData.br[2] * brightness;
        original = originalColors[3];
        this.quadColors[3] = ColorABGR.withAlpha((int)original, (float)(alphaStart * ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackAlpha((int)original))));
        this.brightness[3] = this.quadLightData.br[3] * brightness;
    }
}

