/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.extendedraidar;

import dev.terminalmc.extendedraidar.config.Config;
import dev.terminalmc.extendedraidar.util.ModLogger;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class ExtendedRaidar {
    public static final String MOD_ID = "extendedraidar";
    public static final String MOD_NAME = "ExtendedRaidar";
    public static final ModLogger LOG = new ModLogger("ExtendedRaidar");
    public static final Component PREFIX = Component.empty().append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"ExtendedRaidar").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY)).withStyle(ChatFormatting.GRAY);
    public static final List<KeyMapping> KEYBINDS = List.of();
    @Nullable
    private static BlockPos bellPos;
    @Nullable
    private static Timer timer;

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(Minecraft mc) {
        if (timer != null) {
            timer.tick();
        }
    }

    public static void onConfigSaved(Config config) {
        if (!config.options.modEnabled) {
            ExtendedRaidar.clearData();
        }
    }

    public static void clearData() {
        bellPos = null;
        timer = null;
    }

    public static void onBellRing(BlockPos bellPos) {
        if (!Config.options().modEnabled) {
            return;
        }
        ExtendedRaidar.bellPos = bellPos;
        timer = new Timer(Config.options().highlightDuration * 20);
    }

    public static boolean shouldGlow(Entity entity) {
        LivingEntity livingEntity;
        return bellPos != null && timer != null && timer.get() > 0 && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType().is(EntityTypeTags.RAIDERS) && ExtendedRaidar.isRaiderWithinRange(livingEntity);
    }

    private static boolean isRaiderWithinRange(LivingEntity raider) {
        return raider.isAlive() && !raider.isRemoved() && bellPos != null && bellPos.closerToCenterThan((Position)raider.position(), (double)Config.options().highlightDistance) && raider.getType().is(EntityTypeTags.RAIDERS);
    }

    public static class Timer {
        private int ticks;

        public Timer(int ticks) {
            this.ticks = ticks;
        }

        public int tick() {
            return this.ticks--;
        }

        public int get() {
            return this.ticks;
        }
    }
}

