/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.extendedraidar.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.extendedraidar.ExtendedRaidar;
import dev.terminalmc.extendedraidar.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path DIR_PATH = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "extendedraidar.json";
    private static final String BACKUP_FILE_NAME = "extendedraidar.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    private void cleanup() {
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            ExtendedRaidar.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ExtendedRaidar.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            ExtendedRaidar.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ExtendedRaidar.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.cleanup();
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ExtendedRaidar.onConfigSaved(instance);
        }
        catch (IOException e) {
            ExtendedRaidar.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final boolean modEnabledDefault = true;
        public boolean modEnabled = true;
        public static final int highlightDistanceDefault = 128;
        public int highlightDistance = 128;
        public static final int highlightDurationDefault = 20;
        public int highlightDuration = 20;
    }
}

