/*
 * Decompiled with CFR 0.152.
 */
package com.maxleiter.tilefinder.client;

import com.maxleiter.tilefinder.client.PathHighlighter;
import com.maxleiter.tilefinder.client.TileFinderScreen;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="tilefinder", value={Dist.CLIENT})
public final class KeyBindings {
    public static final KeyMapping OPEN_GUI = new KeyMapping("key.tilefinder.open", InputConstants.Type.KEYSYM, 92, "key.categories.tilefinder");
    public static final KeyMapping CLEAR_PATH = new KeyMapping("key.tilefinder.clear", InputConstants.Type.KEYSYM, 79, "key.categories.tilefinder");

    private KeyBindings() {
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(OPEN_GUI);
        event.register(CLEAR_PATH);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        while (OPEN_GUI.consumeClick()) {
            if (mc.screen != null) continue;
            mc.setScreen((Screen)new TileFinderScreen());
        }
        while (CLEAR_PATH.consumeClick()) {
            PathHighlighter.clear();
        }
    }
}

