/*
 * Decompiled with CFR 0.152.
 */
package com.maxleiter.tilefinder.client;

import com.maxleiter.tilefinder.Config;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="tilefinder", value={Dist.CLIENT})
public class PathHighlighter {
    private static BlockPos targetPos = null;

    public static void setTarget(BlockPos pos) {
        targetPos = pos;
    }

    public static void clear() {
        targetPos = null;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (targetPos == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        Vec3 playerPos = mc.player.getEyePosition();
        Vec3 lookVec = mc.player.getLookAngle();
        double offsetDistance = 2.0;
        double sideOffset = 0.5;
        Vec3 rightVec = new Vec3(-lookVec.z, 0.0, lookVec.x).normalize();
        Vec3 startPos = playerPos.add(lookVec.scale(offsetDistance)).add(rightVec.scale(sideOffset));
        Vec3 endPos = Vec3.atCenterOf((Vec3i)targetPos);
        PathHighlighter.renderHighlightBox(poseStack, (MultiBufferSource)bufferSource, cameraPos, targetPos);
        if (((Boolean)Config.ENABLE_BEAM.get()).booleanValue()) {
            PathHighlighter.renderBeam(poseStack, (MultiBufferSource)bufferSource, cameraPos, startPos, endPos);
        }
        bufferSource.endBatch();
    }

    private static void renderBeam(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos, Vec3 start, Vec3 end) {
        Vec3 up;
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.debugLineStrip((double)2.0));
        Matrix4f matrix = poseStack.last().pose();
        Vec3 relativeStart = start.subtract(cameraPos);
        Vec3 relativeEnd = end.subtract(cameraPos);
        Vec3 direction = relativeEnd.subtract(relativeStart);
        double distance = direction.length();
        Vec3 normalizedDir = direction.normalize();
        Vec3 perpendicular1 = Math.abs(normalizedDir.dot(up = new Vec3(0.0, 1.0, 0.0))) > 0.99 ? normalizedDir.cross(new Vec3(1.0, 0.0, 0.0)).normalize() : normalizedDir.cross(up).normalize();
        Vec3 perpendicular2 = normalizedDir.cross(perpendicular1).normalize();
        double helixRadius = (Double)Config.HELIX_RADIUS.get();
        double helixSpeed = (Double)Config.HELIX_SPEED.get();
        double arcScale = (Double)Config.ARC_SCALE.get();
        double time = (double)System.currentTimeMillis() / 1000.0;
        int segments = Math.max(30, (int)(distance * 6.0));
        Vec3 prevPos1 = null;
        Vec3 prevPos2 = null;
        for (int i = 0; i <= segments; ++i) {
            double t = (double)i / (double)segments;
            double arcHeight = Math.sin(Math.PI * t) * Math.min(arcScale, distance / 3.0);
            Vec3 basePos = relativeStart.add(normalizedDir.scale(distance * t)).add(0.0, arcHeight, 0.0);
            double rotations = helixSpeed * 3.0;
            double angle1 = t * Math.PI * 2.0 * rotations + time * 2.0;
            double x1 = Math.cos(angle1) * helixRadius;
            double y1 = Math.sin(angle1) * helixRadius;
            Vec3 helixOffset1 = perpendicular1.scale(x1).add(perpendicular2.scale(y1));
            Vec3 pos1 = basePos.add(helixOffset1);
            double angle2 = angle1 + Math.PI;
            double x2 = Math.cos(angle2) * helixRadius;
            double y2 = Math.sin(angle2) * helixRadius;
            Vec3 helixOffset2 = perpendicular1.scale(x2).add(perpendicular2.scale(y2));
            Vec3 pos2 = basePos.add(helixOffset2);
            if (prevPos1 != null) {
                consumer.addVertex(matrix, (float)prevPos1.x, (float)prevPos1.y, (float)prevPos1.z).setColor(Config.helixColor1Red, Config.helixColor1Green, Config.helixColor1Blue, 255);
                consumer.addVertex(matrix, (float)pos1.x, (float)pos1.y, (float)pos1.z).setColor(Config.helixColor1Red, Config.helixColor1Green, Config.helixColor1Blue, 255);
                consumer.addVertex(matrix, (float)prevPos2.x, (float)prevPos2.y, (float)prevPos2.z).setColor(Config.helixColor2Red, Config.helixColor2Green, Config.helixColor2Blue, 255);
                consumer.addVertex(matrix, (float)pos2.x, (float)pos2.y, (float)pos2.z).setColor(Config.helixColor2Red, Config.helixColor2Green, Config.helixColor2Blue, 255);
            }
            prevPos1 = pos1;
            prevPos2 = pos2;
        }
    }

    private static void renderHighlightBox(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos, BlockPos pos) {
        AABB box = new AABB(pos).inflate(0.02);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)bufferSource.getBuffer(RenderType.debugLineStrip((double)2.0)), (double)(box.minX - cameraPos.x), (double)(box.minY - cameraPos.y), (double)(box.minZ - cameraPos.z), (double)(box.maxX - cameraPos.x), (double)(box.maxY - cameraPos.y), (double)(box.maxZ - cameraPos.z), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

