/*
 * Decompiled with CFR 0.152.
 */
package com.maxleiter.tilefinder.client;

import com.maxleiter.tilefinder.Config;
import com.maxleiter.tilefinder.client.ChipButton;
import com.maxleiter.tilefinder.client.GuiUtils;
import com.maxleiter.tilefinder.client.PathHighlighter;
import com.maxleiter.tilefinder.client.TileEntry;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class TileFinderScreen
extends Screen {
    private static final int PAD = 16;
    private int radius;
    private final List<TileEntry> tiles = new ArrayList<TileEntry>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private EditBox filterField;
    private Map<String, Integer> nameCollisionCount = new HashMap<String, Integer>();
    private Map<String, Set<String>> nameToMods = new HashMap<String, Set<String>>();
    private static final Deque<String> history = new ArrayDeque<String>();
    private int histIndex = -1;
    private Set<String> modSuggestions = new HashSet<String>();
    private Set<String> nameSuggestions = new HashSet<String>();
    private static SortMode lastSort = SortMode.DISTANCE;
    private SortMode sortMode = lastSort;
    private static GroupMode lastGroupMode = GroupMode.NONE;
    private GroupMode groupMode = lastGroupMode;

    public TileFinderScreen() {
        super((Component)Component.translatable((String)"screen.tilefinder.title"));
        this.radius = Config.defaultRadius;
    }

    protected void init() {
        this.filterField = new EditBox(this.font, 16, 16, 120, 15, (Component)Component.literal((String)"Filter"));
        this.filterField.setMaxLength(50);
        this.filterField.setFocused(false);
        this.addRenderableWidget((GuiEventListener)this.filterField);
        this.refreshTileList();
        this.buildButtons();
    }

    private void buildButtons() {
        this.addRenderableWidget((GuiEventListener)new ChipButton(this.width / 2 - 40, this.height - 30, 80, 18, (Component)Component.literal((String)"Done"), btn -> this.onClose()));
        int btnY = 16;
        this.addRenderableWidget((GuiEventListener)new ChipButton(140, btnY, 18, 14, (Component)Component.literal((String)"-"), btn -> {
            if (this.radius > 8) {
                this.radius -= 8;
            }
            this.refreshTileList();
        }));
        this.addRenderableWidget((GuiEventListener)new ChipButton(162, btnY, 18, 14, (Component)Component.literal((String)"+"), btn -> {
            if (this.radius < 128) {
                this.radius += 8;
            }
            this.refreshTileList();
        }));
        this.addRenderableWidget((GuiEventListener)new ChipButton(190, btnY, 70, 14, (Component)Component.literal((String)("Group: " + this.groupMode.name())), btn -> {
            lastGroupMode = this.groupMode = (switch (this.groupMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> GroupMode.FAV;
                case 1 -> GroupMode.NAME;
                case 2 -> GroupMode.MODID;
                case 3 -> GroupMode.NONE;
            });
            btn.setMessage((Component)Component.literal((String)("Group: " + this.groupMode.name())));
            this.refreshTileList();
        }));
        int sortW = this.font.width("Sort: " + this.sortMode.name()) + 12;
        this.addRenderableWidget((GuiEventListener)new ChipButton(270, btnY, sortW, 14, (Component)Component.literal((String)("Sort: " + this.sortMode.name())), btn -> {
            lastSort = this.sortMode = (switch (this.sortMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SortMode.NAME;
                case 1 -> SortMode.MODID;
                case 2 -> SortMode.DISTANCE;
            });
            btn.setMessage((Component)Component.literal((String)("Sort: " + this.sortMode.name())));
            btn.setWidth(this.font.width((FormattedText)btn.getMessage()) + 12);
            this.refreshTileList();
        }));
        this.addRenderableWidget((GuiEventListener)new ChipButton(this.width - 70, this.height - 25, 65, 20, (Component)Component.literal((String)"GitHub"), button -> {
            try {
                Desktop.getDesktop().browse(URI.create("https://github.com/maxleiter/tilefinder"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    private void refreshTileList() {
        boolean autoGroupLarge;
        this.tiles.clear();
        if (this.minecraft == null || this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        BlockPos playerPos = this.minecraft.player.blockPosition();
        Vec3 playerVec = this.minecraft.player.position();
        String filterRaw = this.filterField != null ? this.filterField.getValue() : "";
        String filter = filterRaw.toLowerCase(Locale.ROOT);
        String modFilter = filter.startsWith("@") ? filter.substring(1) : null;
        List<Object> raw = new ArrayList();
        int chunkX = playerPos.getX() >> 4;
        int chunkZ = playerPos.getZ() >> 4;
        int chunkRadius = (this.radius >> 4) + 1;
        for (int x = chunkX - chunkRadius; x <= chunkX + chunkRadius; ++x) {
            for (int z = chunkZ - chunkRadius; z <= chunkZ + chunkRadius; ++z) {
                LevelChunk chunk = this.minecraft.level.getChunk(x, z);
                for (BlockPos pos : chunk.getBlockEntitiesPos()) {
                    BlockEntity be2;
                    if (pos.distSqr((Vec3i)playerPos) > (double)(this.radius * this.radius) || (be2 = this.minecraft.level.getBlockEntity(pos)) == null || this.isSecondaryChest(be2)) continue;
                    raw.add(be2);
                }
            }
        }
        boolean bl = autoGroupLarge = this.groupMode == GroupMode.NONE;
        if (this.groupMode == GroupMode.FAV) {
            raw = raw.stream().filter(be -> Config.favorites.contains(this.posKey(new TileEntry((BlockEntity)be, playerVec)))).collect(Collectors.toList());
        }
        if (this.groupMode == GroupMode.NAME || this.groupMode == GroupMode.MODID || autoGroupLarge) {
            Function<BlockEntity, String> keyFunc = this.groupMode == GroupMode.MODID ? be -> be.getBlockState().getBlock().builtInRegistryHolder().key().location().getNamespace() : GuiUtils::getDisplayName;
            raw.stream().collect(Collectors.groupingBy(keyFunc)).forEach((name, list) -> {
                BlockEntity closest = list.stream().min(Comparator.comparingDouble(te -> te.getBlockPos().distSqr((Vec3i)playerPos))).orElse(null);
                if (closest != null) {
                    final int cnt = list.size();
                    if (autoGroupLarge && cnt < 20 && this.groupMode == GroupMode.NONE) {
                        list.forEach(be -> {
                            TileEntry e = new TileEntry((BlockEntity)be, playerVec);
                            if (this.testFilters(e, filter, modFilter)) {
                                this.tiles.add(e);
                            }
                        });
                    } else {
                        TileEntry entry = new TileEntry(this, closest, playerVec){
                            final int count;
                            {
                                super(arg0, arg1);
                                this.count = cnt;
                            }

                            public String toString() {
                                return super.toString() + " x" + this.count;
                            }
                        };
                        if (this.testFilters(entry, filter, modFilter)) {
                            this.tiles.add(entry);
                        }
                    }
                }
            });
        } else {
            raw.forEach(be -> {
                TileEntry entry = new TileEntry((BlockEntity)be, playerVec);
                if (this.testFilters(entry, filter, modFilter)) {
                    this.tiles.add(entry);
                }
            });
        }
        switch (this.sortMode.ordinal()) {
            case 0: {
                this.tiles.sort(Comparator.comparingDouble(e -> e.distance));
                break;
            }
            case 1: {
                this.tiles.sort(Comparator.comparing(e -> e.blockName.toLowerCase(Locale.ROOT)));
                break;
            }
            case 2: {
                this.tiles.sort(Comparator.comparing(e -> e.modId));
            }
        }
        this.nameCollisionCount.clear();
        this.nameToMods.clear();
        for (TileEntry e2 : this.tiles) {
            this.nameCollisionCount.merge(e2.blockName, 1, Integer::sum);
            this.nameToMods.computeIfAbsent(e2.blockName, k -> new HashSet()).add(e2.modId);
        }
        int listTop = 40;
        int listBottom = this.height - 50;
        int listHeight = listBottom - listTop;
        this.maxScroll = Math.max(0, this.tiles.size() * 20 - listHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
        this.modSuggestions.clear();
        this.nameSuggestions.clear();
        raw.forEach(be -> {
            this.modSuggestions.add(be.getBlockState().getBlock().builtInRegistryHolder().key().location().getNamespace());
            this.nameSuggestions.add(GuiUtils.getDisplayName(be));
        });
    }

    private boolean testFilters(TileEntry entry, String text, String mod) {
        if (mod != null) {
            return entry.modId.toLowerCase(Locale.ROOT).contains(mod);
        }
        return entry.blockName.toLowerCase(Locale.ROOT).contains(text);
    }

    private boolean isSecondaryChest(BlockEntity be) {
        if (!(be instanceof ChestBlockEntity)) {
            return false;
        }
        ChestBlockEntity chest = (ChestBlockEntity)be;
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos adjacent = chest.getBlockPos().relative(facing);
            BlockEntity other = chest.getLevel().getBlockEntity(adjacent);
            if (!(other instanceof ChestBlockEntity) || facing != Direction.WEST && facing != Direction.NORTH) continue;
            return true;
        }
        return false;
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        gfx.drawString(this.font, "Filter:", 16, 6, 0xFFFFFF);
        gfx.drawString(this.font, "Rad: " + this.radius, 140, 6, 0xFFFFFF);
        super.render(gfx, mouseX, mouseY, partialTick);
        int listTop = 40;
        int listBottom = this.height - 50;
        gfx.fill(10, listTop - 2, this.width - 16 + 6, listBottom, 0x66000000);
        int y = listTop - this.scrollOffset;
        for (TileEntry entry : this.tiles) {
            int lineHeight = 20;
            if (y + lineHeight > listTop && y < listBottom) {
                int cardLeft = 12;
                int cardRight = this.width - 16 + 4;
                int cardBottom = y + lineHeight - 2;
                boolean hover = mouseX >= cardLeft && mouseX <= cardRight && mouseY >= y && mouseY <= cardBottom;
                int bgColor = hover ? -1439471873 : 0x66000000;
                gfx.fill(cardLeft, y, cardRight, cardBottom, bgColor);
                if (!entry.icon.isEmpty()) {
                    gfx.renderItem(entry.icon, cardLeft + 4, y + 2);
                }
                int textX = cardLeft + 24;
                boolean collideAcrossMods = this.nameToMods.getOrDefault(entry.blockName, Collections.emptySet()).size() > 1;
                String namePart = entry.blockName + (String)(collideAcrossMods ? " (" + GuiUtils.lookupModName(entry.modId) + ")" : "");
                gfx.drawString(this.font, namePart, textX, y + 2, 0xFFFFFF);
                String coordPart = String.format("(%d,%d,%d) %.1fm", entry.pos.getX(), entry.pos.getY(), entry.pos.getZ(), entry.distance);
                gfx.drawString(this.font, coordPart, textX, y + 11, 0xAAAAAA);
                int starX = cardRight - 18;
                boolean isFav = Config.favorites.contains(this.posKey(entry));
                gfx.pose().pushPose();
                gfx.pose().translate((float)starX, (float)y, 0.0f);
                gfx.pose().scale(1.6f, 1.6f, 1.0f);
                gfx.drawString(this.font, isFav ? "\u2605" : "\u2606", 0, 0, isFav ? 0xFFFF55 : 0xFFFFFF);
                gfx.pose().popPose();
            }
            y += 20;
        }
        if (this.maxScroll > 0) {
            int barHeight = Math.max(10, (listBottom - listTop) * (listBottom - listTop) / (listBottom - listTop + this.maxScroll));
            int barY = listTop + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(listBottom - listTop - barHeight));
            gfx.fill(this.width - 8, barY, this.width - 8 + 4, barY + barHeight, -1711276033);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        int listTop = 40;
        int listBottom = this.height - 50;
        if (mouseY < (double)listTop || mouseY > (double)listBottom) {
            return false;
        }
        int relativeY = (int)(mouseY - (double)listTop + (double)this.scrollOffset);
        if (relativeY < 0) {
            return false;
        }
        int index = relativeY / 20;
        if (index >= 0 && index < this.tiles.size()) {
            TileEntry entry = this.tiles.get(index);
            int cardRight = this.width - 16 + 4;
            int starStart = cardRight - 20;
            int starEnd = cardRight - 4;
            int rowY = listTop - this.scrollOffset + index * 20;
            if (mouseX >= (double)starStart && mouseX <= (double)starEnd && mouseY >= (double)rowY && mouseY <= (double)(rowY + 16)) {
                String key = this.posKey(entry);
                if (Config.favorites.contains(key)) {
                    Config.favorites.remove(key);
                } else {
                    Config.favorites.add(key);
                }
                Config.saveFavorites();
                this.refreshTileList();
                return true;
            }
            PathHighlighter.setTarget(entry.pos);
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalDelta, double verticalDelta) {
        if (this.maxScroll == 0) {
            return super.mouseScrolled(mouseX, mouseY, horizontalDelta, verticalDelta);
        }
        this.scrollOffset -= (int)(verticalDelta * 12.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 264 && keyCode != 265 || history.isEmpty())) {
            if (this.histIndex == -1) {
                this.histIndex = history.size();
            }
            this.histIndex += keyCode == 265 ? -1 : 1;
            this.histIndex = Math.max(0, Math.min(this.histIndex, history.size() - 1));
            String val = new ArrayList<String>(history).get(this.histIndex);
            this.filterField.setValue(val);
            this.refreshTileList();
            return true;
        }
        if (keyCode == 258) {
            String txt = this.filterField.getValue();
            if (txt.startsWith("@")) {
                String sub = txt.substring(1).toLowerCase(Locale.ROOT);
                for (String m : this.modSuggestions) {
                    if (!m.toLowerCase(Locale.ROOT).startsWith(sub)) continue;
                    this.filterField.setValue("@" + m);
                    this.refreshTileList();
                    break;
                }
            } else {
                for (String n : this.nameSuggestions) {
                    if (!n.toLowerCase(Locale.ROOT).startsWith(txt.toLowerCase(Locale.ROOT))) continue;
                    this.filterField.setValue(n);
                    this.refreshTileList();
                    break;
                }
            }
            return true;
        }
        if (keyCode == 257) {
            String txt = this.filterField.getValue();
            if (!(txt.isEmpty() || !history.isEmpty() && history.peekLast().equals(txt))) {
                history.addLast(txt);
                if (history.size() > 20) {
                    history.removeFirst();
                }
            }
            this.histIndex = -1;
        }
        if (this.filterField.keyPressed(keyCode, scanCode, modifiers) || this.filterField.canConsumeInput()) {
            this.refreshTileList();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.filterField.charTyped(codePoint, modifiers)) {
            this.refreshTileList();
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private String posKey(TileEntry e) {
        return String.valueOf(this.minecraft.level.dimension().location()) + ":" + e.pos.getX() + ":" + e.pos.getY() + ":" + e.pos.getZ();
    }

    private static enum SortMode {
        DISTANCE,
        NAME,
        MODID;

    }

    private static enum GroupMode {
        NONE,
        FAV,
        NAME,
        MODID;

    }
}

