/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.tweak_api.api.debuggers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.QuiltLoader;

public final class DebugFileManager {
    private static final Executor FILE_IO_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Debug-File-IO");
        thread.setDaemon(true);
        return thread;
    });
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");

    private DebugFileManager() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    @NotNull
    public static Path getDebugDirectory() throws IOException {
        Path gameDir = QuiltLoader.getGameDir();
        Path debugDir = gameDir.resolve("debug");
        if (!Files.exists(debugDir, new LinkOption[0])) {
            Files.createDirectories(debugDir, new FileAttribute[0]);
        }
        return debugDir;
    }

    @NotNull
    public static String generateDebugFilename(@Nullable String prefix, @NotNull String extension) {
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
        if (prefix == null || prefix.trim().isEmpty()) {
            return String.format("debug_%s.%s", timestamp, extension);
        }
        return String.format("%s_%s.%s", prefix.trim(), timestamp, extension);
    }

    @NotNull
    public static CompletableFuture<Path> writeDebugFile(@Nullable String filenamePrefix, @NotNull String content) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                String filename = DebugFileManager.generateDebugFilename(filenamePrefix, "txt");
                Path filePath = debugDir.resolve(filename);
                Files.writeString(filePath, (CharSequence)content, new OpenOption[0]);
                return filePath;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write debug file", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<Path> writeDebugFile(@Nullable String filenamePrefix, @NotNull List<String> lines) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                String filename = DebugFileManager.generateDebugFilename(filenamePrefix, "txt");
                Path filePath = debugDir.resolve(filename);
                Files.write(filePath, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
                return filePath;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write debug file lines", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<Path> appendDebugFile(@NotNull String filename, @NotNull String content) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                Path filePath = debugDir.resolve(filename);
                if (Files.exists(filePath, new LinkOption[0])) {
                    String existingContent = Files.readString(filePath);
                    Files.writeString(filePath, (CharSequence)(existingContent + "\n" + content), new OpenOption[0]);
                } else {
                    Files.writeString(filePath, (CharSequence)content, new OpenOption[0]);
                }
                return filePath;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to append to debug file", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<Path> createDebugFile(@Nullable String filenamePrefix) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                String filename = DebugFileManager.generateDebugFilename(filenamePrefix, "txt");
                Path filePath = debugDir.resolve(filename);
                Files.createFile(filePath, new FileAttribute[0]);
                return filePath;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create debug file", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<String> readDebugFile(@NotNull String filename) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                Path filePath = debugDir.resolve(filename);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    throw new RuntimeException("Debug file not found: " + filename);
                }
                return Files.readString(filePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read debug file", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<Boolean> deleteDebugFile(@NotNull String filename) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                Path filePath = debugDir.resolve(filename);
                return Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete debug file", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static CompletableFuture<List<String>> listDebugFiles() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path debugDir = DebugFileManager.getDebugDirectory();
                return Files.list(debugDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).toList();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to list debug files", e);
            }
        }, FILE_IO_EXECUTOR);
    }

    @NotNull
    public static Path getDebugFilePath(@NotNull String filename) throws IOException {
        Path debugDir = DebugFileManager.getDebugDirectory();
        return debugDir.resolve(filename);
    }
}

