/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.tweak_api.api.debuggers;

import io.github.zhengzhengyiyi.tweak_api.Debughelper;
import io.github.zhengzhengyiyi.tweak_api.api.Debugger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Identifier;

public class ProfilingDebugger
implements Debugger {
    private final Identifier id;
    private boolean enabled = true;
    private final Map<String, TimingData> timings = new HashMap<String, TimingData>();
    private int tickCount = 0;

    public ProfilingDebugger(Identifier id) {
        this.id = id;
    }

    public ProfilingDebugger() {
        this(Identifier.of((String)"debug", (String)"profiler"));
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.clear();
        }
    }

    public void startTiming(String operationName) {
        if (!this.enabled) {
            return;
        }
        this.timings.computeIfAbsent(operationName, k -> new TimingData()).start();
    }

    public void stopTiming(String operationName) {
        if (!this.enabled) {
            return;
        }
        TimingData data = this.timings.get(operationName);
        if (data != null) {
            data.stop();
        }
    }

    public TimingScope timeScope(String operationName) {
        return new TimingScope(operationName);
    }

    public void clear() {
        this.timings.clear();
        this.tickCount = 0;
    }

    public long getAverageTime(String operationName) {
        TimingData data = this.timings.get(operationName);
        return data != null ? data.getAverageTime() : 0L;
    }

    public long getCallCount(String operationName) {
        TimingData data = this.timings.get(operationName);
        return data != null ? data.callCount : 0L;
    }

    public Map<String, TimingStats> getStats() {
        HashMap<String, TimingStats> stats = new HashMap<String, TimingStats>();
        for (Map.Entry<String, TimingData> entry : this.timings.entrySet()) {
            TimingData data = entry.getValue();
            stats.put(entry.getKey(), new TimingStats(data.totalTime, data.callCount, data.getAverageTime()));
        }
        return stats;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!this.enabled) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount % 20 == 0) {
            this.printPerformanceReport(server);
        }
    }

    private void printPerformanceReport(MinecraftServer server) {
        if (this.timings.isEmpty()) {
            return;
        }
        System.out.println("=== Performance Profiling Report ===");
        System.out.println("Server Tick: " + this.tickCount);
        for (Map.Entry<String, TimingData> entry : this.timings.entrySet()) {
            TimingData data = entry.getValue();
            if (data.callCount <= 0L) continue;
            double avgMs = TimeUnit.NANOSECONDS.toMillis(data.getAverageTime());
            double totalMs = TimeUnit.NANOSECONDS.toMillis(data.totalTime);
            System.out.printf("Operation: %s | Calls: %d | Avg: %.2fms | Total: %.2fms%n", entry.getKey(), data.callCount, avgMs, totalMs);
        }
        System.out.println("===================================");
    }

    @Override
    public void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (Debughelper.debug(null) && this.enabled) {
                this.tick(server);
            }
        });
    }

    private static class TimingData {
        long totalTime = 0L;
        long callCount = 0L;
        long lastStartTime = 0L;

        private TimingData() {
        }

        void start() {
            this.lastStartTime = System.nanoTime();
        }

        void stop() {
            if (this.lastStartTime > 0L) {
                this.totalTime += System.nanoTime() - this.lastStartTime;
                ++this.callCount;
                this.lastStartTime = 0L;
            }
        }

        long getAverageTime() {
            return this.callCount > 0L ? this.totalTime / this.callCount : 0L;
        }
    }

    public class TimingScope
    implements AutoCloseable {
        private final String operationName;

        public TimingScope(String operationName) {
            this.operationName = operationName;
            ProfilingDebugger.this.startTiming(operationName);
        }

        @Override
        public void close() {
            ProfilingDebugger.this.stopTiming(this.operationName);
        }
    }

    public record TimingStats(long totalTime, long callCount, long averageTime) {
        public double getTotalMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.totalTime);
        }

        public double getAverageMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.averageTime);
        }
    }
}

