/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.tweak_api.api.util;

import io.github.zhengzhengyiyi.tweak_api.api.debuggers.DebugFileManager;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.MinecraftServer;
import org.quiltmc.loader.api.QuiltLoader;

public class DetailedLogger {
    private final String modId;

    public DetailedLogger(String modId) {
        this.modId = modId;
    }

    public CompletableFuture<Path> logServerDetails(MinecraftServer server) {
        StringBuilder content = new StringBuilder();
        content.append("=== Server Detailed Report ===\n");
        content.append("Generated: ").append(LocalDateTime.now()).append("\n\n");
        content.append("--- Server Configuration ---\n");
        content.append("Minecraft Version: ").append(QuiltLoader.getRawGameVersion()).append("\n");
        content.append("Mod Loader: Fabric\n");
        content.append("Server Version: ").append(server.getVersion()).append("\n");
        content.append("Player Count: ").append(server.getPlayerCount()).append("/").append(server.getMaxPlayerCount()).append("\n");
        content.append("World Name: ").append(server.getSaveProperties().getWorldName()).append("\n");
        content.append("Difficulty: ").append(server.getSaveProperties().getDifficulty()).append("\n");
        content.append("Game Mode: ").append(server.getDefaultGameMode()).append("\n\n");
        content.append("--- Performance Metrics ---\n");
        content.append("Memory Usage: ").append(this.getMemoryUsage()).append("\n");
        content.append("Uptime: ").append(ManagementFactory.getRuntimeMXBean().getUptime() / 1000L).append("s\n\n");
        return DebugFileManager.writeDebugFile(this.modId + "_server_details", content.toString());
    }

    public CompletableFuture<Path> logSystemMetrics() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapUsage = memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = memoryBean.getNonHeapMemoryUsage();
        StringBuilder content = new StringBuilder();
        content.append("=== System Metrics Report ===\n");
        content.append("Timestamp: ").append(LocalDateTime.now()).append("\n\n");
        content.append("--- Memory Usage ---\n");
        content.append("Heap Memory: ").append(heapUsage.getUsed() / 1024L / 1024L).append("MB/").append(heapUsage.getMax() / 1024L / 1024L).append("MB\n");
        content.append("Non-Heap Memory: ").append(nonHeapUsage.getUsed() / 1024L / 1024L).append("MB/").append(nonHeapUsage.getMax() / 1024L / 1024L).append("MB\n");
        content.append("--- Thread Information ---\n");
        content.append("Thread Count: ").append(ManagementFactory.getThreadMXBean().getThreadCount()).append("\n");
        content.append("Peak Thread Count: ").append(ManagementFactory.getThreadMXBean().getPeakThreadCount()).append("\n");
        content.append("--- Operating System ---\n");
        content.append("OS: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("\n");
        content.append("Architecture: ").append(System.getProperty("os.arch")).append("\n");
        content.append("Available Processors: ").append(Runtime.getRuntime().availableProcessors()).append("\n");
        return DebugFileManager.writeDebugFile(this.modId + "_system_metrics", content.toString());
    }

    public CompletableFuture<Path> logGarbageCollectionStats() {
        StringBuilder content = new StringBuilder();
        content.append("=== Garbage Collection Report ===\n");
        content.append("Timestamp: ").append(LocalDateTime.now()).append("\n\n");
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            content.append("GC: ").append(gcBean.getName()).append("\n");
            content.append("  Collection Count: ").append(gcBean.getCollectionCount()).append("\n");
            content.append("  Collection Time: ").append(gcBean.getCollectionTime()).append("ms\n");
        }
        return DebugFileManager.writeDebugFile(this.modId + "_gc_stats", content.toString());
    }

    private String getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L / 1024L;
        return usedMemory + "MB/" + maxMemory + "MB";
    }
}

