/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.tweak_api.example;

import io.github.zhengzhengyiyi.tweak_api.api.debuggers.DebugFileManager;
import io.github.zhengzhengyiyi.tweak_api.api.debuggers.ProfilingDebugger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example {
    private final String modId;
    private final ProfilingDebugger profiler;
    private final List<String> events;
    private final List<String> profilingData;
    private final Logger LOGGER = LoggerFactory.getLogger(Example.class);
    private static final Logger STATIC_LOGGER = LoggerFactory.getLogger(Example.class);

    public Example(String modId) {
        this.modId = modId;
        this.profiler = new ProfilingDebugger(new Identifier(modId, "example_profiler"));
        this.events = new ArrayList<String>();
        this.profilingData = new ArrayList<String>();
        this.profiler.setEnabled(true);
        this.profiler.register();
    }

    public static CompletableFuture<Void> quickLog(String modId, String message) {
        String formattedMessage = "[" + String.valueOf(LocalDateTime.now()) + "] " + message;
        STATIC_LOGGER.info("Quick log: {}", (Object)formattedMessage);
        return DebugFileManager.writeDebugFile(modId + "_quick_log", formattedMessage).thenAccept(path -> STATIC_LOGGER.info("Quick log saved to: {}", path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<Void> quickProfile(String modId, String operationName, Runnable runnable) {
        ProfilingDebugger tempProfiler = new ProfilingDebugger(new Identifier(modId, "quick_profiler"));
        tempProfiler.setEnabled(true);
        tempProfiler.startTiming(operationName);
        try {
            runnable.run();
        }
        finally {
            tempProfiler.stopTiming(operationName);
        }
        long avgTime = tempProfiler.getAverageTime(operationName);
        long callCount = tempProfiler.getCallCount(operationName);
        String content = String.format("Quick Profile - Operation: %s | Calls: %d | Avg: %.2fms", operationName, callCount, (double)avgTime / 1000000.0);
        STATIC_LOGGER.info(content);
        return DebugFileManager.writeDebugFile(modId + "_quick_profile", content).thenAccept(path -> STATIC_LOGGER.info("Quick profile saved to: {}", path));
    }

    public static CompletableFuture<Void> quickSaveLines(String modId, String filenameSuffix, List<String> lines) {
        return DebugFileManager.writeDebugFile(modId + "_" + filenameSuffix, lines).thenAccept(path -> STATIC_LOGGER.info("Lines saved to: {}", path));
    }

    public static CompletableFuture<Void> quickAppend(String modId, String filename, String message) {
        String formattedMessage = "[" + String.valueOf(LocalDateTime.now()) + "] " + message;
        return DebugFileManager.appendDebugFile(filename, formattedMessage).thenAccept(path -> STATIC_LOGGER.info("Message appended to: {}", path));
    }

    public static String getDebugDirectoryPath(String modId) {
        try {
            return DebugFileManager.getDebugDirectory().resolve(modId).toString();
        }
        catch (Exception e) {
            STATIC_LOGGER.warn("Failed to get debug directory path: {}", (Object)e.getMessage());
            return "./debug/" + modId;
        }
    }

    public static boolean isGlobalDebugEnabled() {
        return System.getProperty("debug.mode", "false").equalsIgnoreCase("true") || System.getenv("DEBUG_MODE") != null;
    }

    public static String getTimestamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public void startProfiling(String operationName) {
        this.profiler.startTiming(operationName);
    }

    public void stopProfiling(String operationName) {
        this.profiler.stopTiming(operationName);
        long avgTime = this.profiler.getAverageTime(operationName);
        long callCount = this.profiler.getCallCount(operationName);
        this.profilingData.add(String.format("Operation: %s | Calls: %d | Avg: %.2fms", operationName, callCount, (double)avgTime / 1000000.0));
    }

    public void logEvent(String message) {
        String formattedMessage = "[" + String.valueOf(LocalDateTime.now()) + "] " + message;
        this.events.add(formattedMessage);
        this.LOGGER.info("Event logged: " + formattedMessage);
    }

    public CompletableFuture<Void> saveDebugData() {
        StringBuilder content = new StringBuilder();
        content.append("=== Debug Data Report ===\n");
        content.append("Mod: ").append(this.modId).append("\n");
        content.append("Generated: ").append(LocalDateTime.now()).append("\n\n");
        if (!this.profilingData.isEmpty()) {
            content.append("--- Performance Profiling ---\n");
            for (String data : this.profilingData) {
                content.append(data).append("\n");
            }
            content.append("\n");
        }
        if (!this.events.isEmpty()) {
            content.append("--- Event Log ---\n");
            for (String event : this.events) {
                content.append(event).append("\n");
            }
        }
        content.append("=== End of Report ===\n");
        return DebugFileManager.writeDebugFile(this.modId + "_debug", content.toString()).thenAccept(path -> {
            this.LOGGER.info("All debug data saved to: " + String.valueOf(path));
            this.events.clear();
            this.profilingData.clear();
        });
    }

    public void runExampleWorkflow() {
        try {
            this.startProfiling("mod_initialization");
            Thread.sleep(50L);
            this.stopProfiling("mod_initialization");
            this.startProfiling("data_loading");
            Thread.sleep(30L);
            this.stopProfiling("data_loading");
            this.logEvent("Mod initialization started");
            this.logEvent("Configuration loaded");
            this.logEvent("Event system initialized");
            this.saveDebugData().get();
            this.logEvent("Debug data saved successfully");
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOGGER.error("Example workflow failed: " + e.getMessage());
            this.logEvent("Workflow failed: " + e.getMessage());
        }
    }

    public void clearData() {
        this.events.clear();
        this.profilingData.clear();
        this.profiler.clear();
    }

    public int getEventCount() {
        return this.events.size();
    }

    public int getProfilingRecordCount() {
        return this.profilingData.size();
    }
}

