/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Kit
implements Cloneable {
    private final String name;
    private Material icon = Material.BOOK;
    private int modelData = -1;
    private long cooldown;
    private String permissionRequired;
    private final Map<String, KitEntry> items;
    private final Collection<String> commands;
    private String displayName;
    private String description;
    private double price;

    public Kit(String name, long cooldown, String permissionRequired, double price, String displayName, String description, Collection<String> commands, Map<String, KitEntry> items) {
        this.name = name;
        this.cooldown = cooldown;
        this.permissionRequired = permissionRequired;
        this.items = items;
        this.price = price;
        this.commands = commands;
        this.displayName = displayName;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Material getIcon() {
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public void setModelData(int modelData) {
        this.modelData = modelData;
    }

    public int getModelData() {
        return this.modelData;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public Collection<String> getCommands() {
        return this.commands;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String getPermissionRequired() {
        return this.permissionRequired;
    }

    public void setPermissionRequired(String permissionRequired) {
        this.permissionRequired = permissionRequired;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }

    public Map<String, KitEntry> getItems() {
        return this.items;
    }

    public Kit clone() {
        Kit clone;
        try {
            clone = (Kit)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Exception occurred calling ItemCraftingRecipe.clone()", ex);
        }
        return clone;
    }

    public static class ValhallaKitEntry
    extends KitEntry {
        private List<DynamicItemModifier> modifiers;

        public ValhallaKitEntry(String id, ItemStack i, List<DynamicItemModifier> modifiers) {
            super(id, i);
            this.modifiers = modifiers;
        }

        public List<DynamicItemModifier> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(List<DynamicItemModifier> modifiers) {
            this.modifiers = modifiers;
            DynamicItemModifier.sortModifiers(this.modifiers);
        }

        @Override
        public void giveItem(Player p) {
            ItemBuilder result = new ItemBuilder(this.getItem());
            DynamicItemModifier.modify((ModifierContext)ModifierContext.builder((ItemBuilder)result).crafter(p).executeUsageMechanics().validate().get(), this.modifiers);
            ItemStack item = result.get();
            if (ItemUtils.isEmpty((ItemStack)item)) {
                return;
            }
            Utils.giveItem(p, item);
        }
    }

    public static class KitEntry {
        private ItemStack item;
        private final String id;

        public KitEntry(String id, ItemStack i) {
            this.id = id;
            this.item = i;
        }

        public String getId() {
            return this.id;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public void setItem(ItemStack item) {
            this.item = item;
        }

        public void giveItem(Player p) {
            Utils.giveItem(p, this.item.clone());
        }
    }
}

