/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.ValhallaKits;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitCooldownManager {
    private static KitCooldownManager manager = null;
    private static final NamespacedKey kitCooldownKey = new NamespacedKey((Plugin)ValhallaKits.getPlugin(), "kit_cooldowns");

    public static KitCooldownManager getInstance() {
        if (manager == null) {
            manager = new KitCooldownManager();
        }
        return manager;
    }

    public boolean isKitCooldownExpired(Player p, Kit kit) {
        long cooldown = this.getKitCooldown(p, kit);
        if (cooldown == -1L) {
            return false;
        }
        if (kit.getCooldown() == 0L) {
            return true;
        }
        return cooldown == 0L;
    }

    public long getKitCooldown(Player p, Kit kit) {
        if (kit.getCooldown() == 0L) {
            return 0L;
        }
        if (p.getPersistentDataContainer().has(kitCooldownKey, PersistentDataType.STRING)) {
            String[] stringCooldowns;
            String storedValue = (String)p.getPersistentDataContainer().get(kitCooldownKey, PersistentDataType.STRING);
            if (storedValue == null) {
                return 0L;
            }
            for (String cooldown : stringCooldowns = storedValue.split(";")) {
                String[] args = cooldown.split(":");
                if (args.length < 2) continue;
                try {
                    if (kit.getName().equalsIgnoreCase(args[0])) {
                        long expiredUntil = Long.parseLong(args[1]);
                        if (expiredUntil == -1L) {
                            return -1L;
                        }
                        return Math.max(0L, expiredUntil - System.currentTimeMillis());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    private Map<String, CooldownInstance> getKitCooldowns(Player p) {
        HashMap<String, CooldownInstance> requirements = new HashMap<String, CooldownInstance>();
        if (p.getPersistentDataContainer().has(kitCooldownKey, PersistentDataType.STRING)) {
            String[] stringCooldowns;
            String storedValue = (String)p.getPersistentDataContainer().get(kitCooldownKey, PersistentDataType.STRING);
            if (storedValue == null) {
                return requirements;
            }
            for (String cooldown : stringCooldowns = storedValue.split(";")) {
                String[] args = cooldown.split(":");
                if (args.length < 2) continue;
                try {
                    long cd = Long.parseLong(args[1]);
                    Kit kit = KitManager.getRegisteredKits().get(args[0]);
                    if (kit == null) continue;
                    requirements.put(kit.getName(), new CooldownInstance(kit.getName(), cd));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return requirements;
    }

    private void setKitCooldowns(Player p, Map<String, CooldownInstance> cooldowns) {
        if (cooldowns.isEmpty()) {
            p.getPersistentDataContainer().remove(kitCooldownKey);
        } else {
            StringBuilder cooldownsString = new StringBuilder();
            boolean first = true;
            for (CooldownInstance cooldown : cooldowns.values()) {
                if (cooldown.getExpiredUntil() >= 0L && cooldown.getExpiredUntil() <= System.currentTimeMillis()) continue;
                if (first) {
                    cooldownsString.append(cooldown.getKitName()).append(":").append(cooldown.getExpiredUntil());
                    first = false;
                    continue;
                }
                cooldownsString.append(";").append(cooldown.getKitName()).append(":").append(cooldown.getExpiredUntil());
            }
            p.getPersistentDataContainer().set(kitCooldownKey, PersistentDataType.STRING, (Object)cooldownsString.toString());
        }
    }

    public void setKitCooldown(Player p, Kit kit) {
        this.setKitCooldown(p, kit, kit.getCooldown());
    }

    public void setKitCooldown(Player p, Kit kit, long cooldown) {
        CooldownInstance instance = new CooldownInstance(kit.getName(), cooldown == -1L ? -1L : System.currentTimeMillis() + cooldown);
        Map<String, CooldownInstance> existingCooldowns = this.getKitCooldowns(p);
        existingCooldowns.put(kit.getName(), instance);
        this.setKitCooldowns(p, existingCooldowns);
    }

    private static class CooldownInstance {
        private final long expiredUntil;
        private final String kitName;

        public CooldownInstance(String kitName, long expiredUntil) {
            this.expiredUntil = expiredUntil;
            this.kitName = kitName;
        }

        public long getExpiredUntil() {
            return this.expiredUntil;
        }

        public String getKitName() {
            return this.kitName;
        }
    }
}

