/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.athlaeos.valhallakits.JoinListener;
import me.athlaeos.valhallakits.KitCommand;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.KitsCommand;
import me.athlaeos.valhallakits.config.ConfigUpdater;
import me.athlaeos.valhallakits.hooks.KitsPlaceholderExpansion;
import me.athlaeos.valhallakits.hooks.VaultHook;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ValhallaKits
extends JavaPlugin {
    private static ValhallaKits plugin;
    private static boolean valhallaHooked;
    private static boolean vaultHooked;
    private static VaultHook vaultHook;

    public void onEnable() {
        plugin = this;
        valhallaHooked = this.getServer().getPluginManager().isPluginEnabled("ValhallaMMO");
        vaultHooked = this.getServer().getPluginManager().isPluginEnabled("Vault");
        if (vaultHooked) {
            vaultHook = new VaultHook();
        }
        if (vaultHooked && vaultHook.getEcon() == null) {
            vaultHooked = false;
        }
        new KitsCommand();
        new KitCommand();
        this.saveAndUpdateConfig("config.yml");
        this.save("kits.json");
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        KitManager.registerKitsFromFile(new File(this.getDataFolder(), "/kits.json"));
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new KitsPlaceholderExpansion().register();
        }
    }

    public void onDisable() {
        KitManager.saveKits();
    }

    public void save(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }

    public static VaultHook getVaultHook() {
        return vaultHook;
    }

    public static ValhallaKits getPlugin() {
        return plugin;
    }

    public static boolean isValhallaHooked() {
        return valhallaHooked;
    }

    public static boolean isVaultHooked() {
        return vaultHooked;
    }

    private void saveAndUpdateConfig(String config) {
        this.saveConfig(config);
        this.updateConfig(config);
    }

    public void saveConfig(String name) {
        File config = new File(this.getDataFolder(), name);
        if (!config.exists()) {
            this.saveResource(name, false);
        }
    }

    private void updateConfig(String name) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)plugin, name, configFile, new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        valhallaHooked = false;
        vaultHooked = false;
    }
}

