/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.menus;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.ValhallaKits;
import me.athlaeos.valhallakits.menus.KitEditingMenu;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitSelectionMenu
extends Menu {
    private final NamespacedKey kitKey = new NamespacedKey((Plugin)ValhallaKits.getPlugin(), "kit_key");
    private int pageNumber = 1;
    private final ItemStack nextPageButton = Utils.createItemStack(Material.ARROW, Utils.chat("&fNext Page"), null);
    private final ItemStack previousPageButton = Utils.createItemStack(Material.ARROW, Utils.chat("&fPrevious Page"), null);

    public KitSelectionMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public String getMenuName() {
        return Utils.chat("&8Kit Overview");
    }

    public int getSlots() {
        return 54;
    }

    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(true);
        if (Utils.isItemEmptyOrNull(e.getCurrentItem())) {
            return;
        }
        assert (e.getCurrentItem().getItemMeta() != null);
        if (e.getCurrentItem().equals((Object)this.previousPageButton)) {
            --this.pageNumber;
        } else if (e.getCurrentItem().equals((Object)this.nextPageButton)) {
            ++this.pageNumber;
        } else if (e.getCurrentItem().getItemMeta().getPersistentDataContainer().has(this.kitKey, PersistentDataType.STRING)) {
            String kit = (String)e.getCurrentItem().getItemMeta().getPersistentDataContainer().get(this.kitKey, PersistentDataType.STRING);
            Kit chosenKit = KitManager.getRegisteredKits().get(kit);
            if (chosenKit != null) {
                new KitEditingMenu(this.playerMenuUtility, chosenKit).open();
                return;
            }
            this.playerMenuUtility.getOwner().sendMessage(Utils.chat("&cKit no longer exists"));
            e.getWhoClicked().closeInventory();
        }
        this.setMenuItems();
    }

    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    public void setMenuItems() {
        this.inventory.clear();
        ArrayList<ItemStack> kitButtons = new ArrayList<ItemStack>();
        for (Kit kit : KitManager.getRegisteredKits().values()) {
            ItemStack button = new ItemStack(kit.getIcon());
            ItemMeta buttonMeta = button.getItemMeta();
            if (buttonMeta == null) continue;
            ArrayList<String> buttonLore = new ArrayList<String>(Utils.separateStringIntoLines(Utils.chat(kit.getDescription()), 40));
            buttonLore.add(Utils.chat("&fCooldown: &e" + (kit.getCooldown() < 0L ? "Single Use" : Utils.toTimeStamp(kit.getCooldown(), 1000L))));
            buttonLore.add(Utils.chat("&fRequires permission: &e" + (kit.getPermissionRequired() == null ? "None" : kit.getPermissionRequired())));
            buttonLore.add(Utils.chat("&fCosts: &e$" + String.format("%,.2f", kit.getPrice())));
            if (kit.getCommands().isEmpty()) {
                buttonLore.add(Utils.chat("&fKit executes no commands"));
            } else {
                buttonLore.add(Utils.chat("&fCommands:"));
                for (String cmd : kit.getCommands()) {
                    buttonLore.add(Utils.chat(String.format("&f- &e%s", cmd.length() > 30 ? cmd.substring(0, 30) + "..." : cmd)));
                }
            }
            if (kit.getItems().isEmpty()) {
                buttonLore.add(Utils.chat("&fKit is currently empty"));
            } else {
                buttonLore.add(Utils.chat("&fContents:"));
                for (Kit.KitEntry reward : kit.getItems().values()) {
                    buttonLore.add(Utils.chat(String.format("&f- &e%s &fx%d", Utils.getItemName(reward.getItem()), reward.getItem().getAmount())));
                }
            }
            buttonMeta.setDisplayName(Utils.chat("&r" + kit.getDisplayName()));
            buttonMeta.setLore(buttonLore);
            buttonMeta.getPersistentDataContainer().set(this.kitKey, PersistentDataType.STRING, (Object)kit.getName());
            button.setItemMeta(buttonMeta);
            kitButtons.add(button);
        }
        kitButtons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)Utils.getItemName(item))));
        if (kitButtons.size() >= 45) {
            Map<Integer, ArrayList<ItemStack>> pages = Utils.paginateItemStackList(45, kitButtons);
            if (this.pageNumber > pages.size()) {
                this.pageNumber = pages.size();
            } else if (this.pageNumber < 1) {
                this.pageNumber = 1;
            }
            for (ItemStack button : pages.get(this.pageNumber - 1)) {
                this.inventory.addItem(new ItemStack[]{button});
            }
            if (this.pageNumber < pages.size()) {
                this.inventory.setItem(53, this.nextPageButton);
            }
            if (this.pageNumber > 1) {
                this.inventory.setItem(45, this.previousPageButton);
            }
        } else {
            this.inventory.addItem(kitButtons.toArray(new ItemStack[0]));
        }
    }
}

