/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.menus;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.KitCooldownManager;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.ValhallaKits;
import me.athlaeos.valhallakits.config.ConfigManager;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerKitSelectionMenu
extends Menu {
    private final List<String> kit_format = ConfigManager.getInstance().getConfig("config.yml").get().getStringList("kit_format");
    private final String kit_claimable = ConfigManager.getInstance().getConfig("config.yml").get().getString("kit_claimable", "");
    private final String kit_unclaimable = ConfigManager.getInstance().getConfig("config.yml").get().getString("kit_unclaimable", "");
    private final String kit_free = ConfigManager.getInstance().getConfig("config.yml").get().getString("kit_free", "");
    private final String error_kit_not_found = ConfigManager.getInstance().getConfig("config.yml").get().getString("error_kit_not_found", "");
    private final String status_kit_received = ConfigManager.getInstance().getConfig("config.yml").get().getString("status_kit_received", "");
    private final String error_no_permission = ConfigManager.getInstance().getConfig("config.yml").get().getString("error_no_permission", "");
    private final String warning_kit_cooldown = ConfigManager.getInstance().getConfig("config.yml").get().getString("warning_kit_cooldown", "");
    private final String warning_kit_already_unlocked = ConfigManager.getInstance().getConfig("config.yml").get().getString("warning_kit_already_unlocked", "");
    private final String warning_kit_too_expensive = ConfigManager.getInstance().getConfig("config.yml").get().getString("warning_kit_too_expensive", "");
    private final String kit_menu_title = ConfigManager.getInstance().getConfig("config.yml").get().getString("kit_menu_title", "");
    private final NamespacedKey kitKey = new NamespacedKey((Plugin)ValhallaKits.getPlugin(), "kit_key");
    private int pageNumber = 1;
    private final ItemStack nextPageButton = Utils.createItemStack(Material.ARROW, Utils.chat("&fNext Page"), null);
    private final ItemStack previousPageButton = Utils.createItemStack(Material.ARROW, Utils.chat("&fPrevious Page"), null);

    public PlayerKitSelectionMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public String getMenuName() {
        return Utils.chat(this.kit_menu_title);
    }

    public int getSlots() {
        return 54;
    }

    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(true);
        if (Utils.isItemEmptyOrNull(e.getCurrentItem())) {
            return;
        }
        assert (e.getCurrentItem().getItemMeta() != null);
        if (e.getCurrentItem().equals((Object)this.previousPageButton)) {
            --this.pageNumber;
        } else if (e.getCurrentItem().equals((Object)this.nextPageButton)) {
            ++this.pageNumber;
        } else if (e.getCurrentItem().getItemMeta().getPersistentDataContainer().has(this.kitKey, PersistentDataType.STRING)) {
            String kitName = (String)e.getCurrentItem().getItemMeta().getPersistentDataContainer().get(this.kitKey, PersistentDataType.STRING);
            Player who = this.playerMenuUtility.getOwner();
            Kit kit = KitManager.getRegisteredKits().get(kitName);
            if (kit != null) {
                if (kit.getPermissionRequired() != null && !who.hasPermission("valhallakits.allkits") && !who.hasPermission(kit.getPermissionRequired())) {
                    who.sendMessage(Utils.chat(this.error_no_permission));
                    this.setMenuItems();
                    return;
                }
                if (kit.getPrice() > 0.0 && ValhallaKits.isVaultHooked()) {
                    Economy econ = ValhallaKits.getVaultHook().getEcon();
                    if (econ.getBalance((OfflinePlayer)who) < kit.getPrice()) {
                        who.sendMessage(Utils.chat(this.warning_kit_too_expensive));
                        this.setMenuItems();
                        return;
                    }
                    EconomyResponse response = econ.withdrawPlayer((OfflinePlayer)who, kit.getPrice());
                    if (!response.transactionSuccess()) {
                        who.sendMessage(Utils.chat("&cSomething went wrong with the transaction"));
                        this.setMenuItems();
                        return;
                    }
                }
                if (who.hasPermission("valhallakits.allkits") || KitCooldownManager.getInstance().isKitCooldownExpired(who, kit)) {
                    for (Kit.KitEntry entry : kit.getItems().values()) {
                        entry.giveItem(who);
                    }
                    for (String cmd : kit.getCommands()) {
                        ValhallaKits.getPlugin().getServer().dispatchCommand((CommandSender)ValhallaKits.getPlugin().getServer().getConsoleSender(), cmd.replace("%player%", who.getName()));
                    }
                    KitCooldownManager.getInstance().setKitCooldown(who, kit);
                    who.sendMessage(Utils.chat(this.status_kit_received));
                } else {
                    long cooldown = KitCooldownManager.getInstance().getKitCooldown(who, kit);
                    if (cooldown == -1L) {
                        who.sendMessage(Utils.chat(this.warning_kit_already_unlocked));
                    } else {
                        assert (this.warning_kit_cooldown != null);
                        who.sendMessage(Utils.chat(this.warning_kit_cooldown.replace("%cooldown%", Utils.toTimeStamp(cooldown, 1000L))));
                    }
                }
                return;
            }
            this.playerMenuUtility.getOwner().sendMessage(Utils.chat(this.error_kit_not_found));
            e.getWhoClicked().closeInventory();
        }
        this.setMenuItems();
    }

    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    public void setMenuItems() {
        this.inventory.clear();
        Player who = this.playerMenuUtility.getOwner();
        ArrayList<ItemStack> kitButtons = new ArrayList<ItemStack>();
        for (Kit kit : KitManager.getRegisteredKits().values()) {
            ItemStack button;
            ItemMeta buttonMeta;
            if (kit.getPermissionRequired() != null && !who.hasPermission(kit.getPermissionRequired()) && !who.hasPermission("valhallakits.allkits") || (buttonMeta = (button = new ItemStack(kit.getIcon())).getItemMeta()) == null) continue;
            buttonMeta.setDisplayName(Utils.chat("&r" + kit.getDisplayName()));
            ArrayList<String> buttonLore = new ArrayList<String>();
            for (String formatLine : this.kit_format) {
                if (formatLine.contains("%description%")) {
                    if (kit.getDescription().isEmpty()) continue;
                    buttonLore.addAll(Utils.separateStringIntoLines(Utils.chat(kit.getDescription()), 40));
                    continue;
                }
                if (formatLine.contains("%contents%")) {
                    if (kit.getItems().isEmpty()) continue;
                    for (Kit.KitEntry reward : kit.getItems().values()) {
                        String baseLine = formatLine.replace("%contents%", String.format("%s x%d", Utils.getItemName(reward.getItem()), reward.getItem().getAmount()));
                        buttonLore.add(Utils.chat(baseLine));
                    }
                    continue;
                }
                assert (this.kit_unclaimable != null);
                assert (this.kit_claimable != null);
                assert (this.kit_free != null);
                long cooldown = KitCooldownManager.getInstance().getKitCooldown(who, kit);
                buttonLore.add(Utils.chat(formatLine.replace("%cooldown%", who.hasPermission("valhallakits.allkits") ? this.kit_claimable : (cooldown == -1L ? this.kit_unclaimable : (cooldown == 0L ? this.kit_claimable : Utils.msToTimestamp(cooldown)))).replace("%price%", kit.getPrice() <= 0.0 ? this.kit_free : String.format("%,.2f", kit.getPrice()))));
            }
            buttonMeta.setLore(buttonLore);
            buttonMeta.getPersistentDataContainer().set(this.kitKey, PersistentDataType.STRING, (Object)kit.getName());
            if (kit.getModelData() >= 0) {
                buttonMeta.setCustomModelData(Integer.valueOf(kit.getModelData()));
            }
            button.setItemMeta(buttonMeta);
            kitButtons.add(button);
        }
        kitButtons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)Utils.getItemName(item))));
        if (kitButtons.size() >= 45) {
            Map<Integer, ArrayList<ItemStack>> pages = Utils.paginateItemStackList(45, kitButtons);
            if (this.pageNumber > pages.size()) {
                this.pageNumber = pages.size();
            } else if (this.pageNumber < 1) {
                this.pageNumber = 1;
            }
            for (ItemStack button : pages.get(this.pageNumber - 1)) {
                this.inventory.addItem(new ItemStack[]{button});
            }
            if (this.pageNumber < pages.size()) {
                this.inventory.setItem(53, this.nextPageButton);
            }
            if (this.pageNumber > 1) {
                this.inventory.setItem(45, this.previousPageButton);
            }
        } else {
            this.inventory.addItem(kitButtons.toArray(new ItemStack[0]));
        }
    }
}

