/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.menus.KitEditingMenu;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class ValhallaKitEntryEditingMenu
extends Menu
implements SetModifiersMenu {
    private final Kit.KitEntry entry;
    private final Kit editingKit;
    private final ItemStack dynamicModifierButton = Utils.createItemStack(Material.BOOK, Utils.chat("&aDynamic Item Modifiers"), Arrays.asList(Utils.chat("&fExecutes a number of modifiers on"), Utils.chat("&fthe item before rewarding, allowing"), Utils.chat("&fthe item to have custom properties"), Utils.chat("&fdepending on the player's stats")));
    private final ItemStack saveButton = Utils.createItemStack(Material.STRUCTURE_VOID, Utils.chat("&a&lSave Drop"), null);
    private final ItemStack deleteButton = Utils.createItemStack(Material.BARRIER, Utils.chat("&c&lDelete Drop"), null);
    private ItemStack drop;
    private List<DynamicItemModifier> currentModifiers;

    public ValhallaKitEntryEditingMenu(PlayerMenuUtility playerMenuUtility, Kit editingKit, Kit.KitEntry entry) {
        super(playerMenuUtility);
        this.entry = entry;
        this.editingKit = editingKit;
        this.drop = entry.getItem();
        this.currentModifiers = ((Kit.ValhallaKitEntry)entry).getModifiers();
    }

    public String getMenuName() {
        return Utils.chat("&8Edit Drop");
    }

    public int getSlots() {
        return 45;
    }

    public void handleMenu(InventoryClickEvent e) {
        ItemStack clickedItem;
        e.setCancelled(true);
        if (e.getClickedInventory() instanceof PlayerInventory) {
            e.setCancelled(false);
        }
        if (!Utils.isItemEmptyOrNull(clickedItem = e.getCurrentItem())) {
            if (clickedItem.equals((Object)this.dynamicModifierButton)) {
                this.playerMenuUtility.setPreviousMenu((Menu)this);
                new DynamicModifierMenu(this.playerMenuUtility, (Menu)this).open();
                return;
            }
            if (clickedItem.equals((Object)this.deleteButton)) {
                this.editingKit.getItems().remove(this.entry.getId());
                new KitEditingMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)this.playerMenuUtility.getOwner()), this.editingKit).open();
                return;
            }
            if (clickedItem.equals((Object)this.saveButton)) {
                this.editingKit.getItems().put(this.entry.getId(), new Kit.ValhallaKitEntry(this.entry.getId(), this.drop, this.currentModifiers));
                new KitEditingMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)this.playerMenuUtility.getOwner()), this.editingKit).open();
                return;
            }
            if (clickedItem.equals((Object)this.drop) && !Utils.isItemEmptyOrNull(e.getCursor())) {
                this.drop = e.getCursor().clone();
            }
        }
        this.setMenuItems();
    }

    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    public void setMenuItems() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.inventory.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE));
        }
        ArrayList<String> modifierButtonLore = new ArrayList<String>();
        ArrayList<DynamicItemModifier> modifiers = new ArrayList<DynamicItemModifier>(this.currentModifiers);
        modifiers.sort(Comparator.comparingInt(a -> a.getPriority().getPriorityRating()));
        for (DynamicItemModifier modifier : modifiers) {
            modifierButtonLore.add(Utils.chat("&7- " + modifier.toString()));
        }
        ItemMeta modifierButtonMeta = this.dynamicModifierButton.getItemMeta();
        assert (modifierButtonMeta != null);
        modifierButtonMeta.setLore(modifierButtonLore);
        this.dynamicModifierButton.setItemMeta(modifierButtonMeta);
        this.inventory.setItem(22, this.drop);
        this.inventory.setItem(24, this.dynamicModifierButton);
        this.inventory.setItem(36, this.deleteButton);
        this.inventory.setItem(44, this.saveButton);
    }

    public void setResultModifiers(List<DynamicItemModifier> list) {
        this.currentModifiers = list;
    }

    public List<DynamicItemModifier> getResultModifiers() {
        return this.currentModifiers;
    }
}

