/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import java.util.ArrayList;
import java.util.List;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.KitCooldownManager;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.ValhallaKits;
import me.athlaeos.valhallakits.config.ConfigManager;
import me.athlaeos.valhallakits.menus.PlayerKitSelectionMenu;
import me.athlaeos.valhallakits.menus.PlayerMenuUtilManager;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class KitCommand
implements TabExecutor {
    private final String error_kit_not_found;
    private final String status_kit_received;
    private final String error_no_permission;
    private final String warning_kit_cooldown;
    private final String warning_kit_already_unlocked;
    private final String warning_kit_too_expensive;

    public KitCommand() {
        YamlConfiguration config = ConfigManager.getInstance().getConfig("config.yml").get();
        this.error_kit_not_found = config.getString("error_kit_not_found");
        this.status_kit_received = config.getString("status_kit_received");
        this.error_no_permission = config.getString("error_no_permission");
        this.warning_kit_cooldown = config.getString("warning_kit_cooldown");
        this.warning_kit_already_unlocked = config.getString("warning_kit_already_unlocked");
        this.warning_kit_too_expensive = config.getString("warning_kit_too_expensive");
        PluginCommand cmd = ValhallaKits.getPlugin().getCommand("valhallakit");
        if (cmd == null) {
            return;
        }
        cmd.setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.chat("&cOnly players may execute this command"));
            return true;
        }
        if (args.length >= 1) {
            Kit kit = KitManager.getRegisteredKits().get(args[0]);
            if (kit == null) {
                sender.sendMessage(Utils.chat(this.error_kit_not_found));
                return true;
            }
            if (kit.getPermissionRequired() != null && !sender.hasPermission("valhallakits.allkits") && !sender.hasPermission(kit.getPermissionRequired())) {
                sender.sendMessage(Utils.chat(this.error_no_permission));
                return true;
            }
            if (kit.getPrice() > 0.0 && ValhallaKits.isVaultHooked()) {
                Economy e = ValhallaKits.getVaultHook().getEcon();
                if (e.getBalance((OfflinePlayer)sender) < kit.getPrice()) {
                    sender.sendMessage(Utils.chat(this.warning_kit_too_expensive));
                    return true;
                }
                EconomyResponse response = e.withdrawPlayer((OfflinePlayer)sender, kit.getPrice());
                if (!response.transactionSuccess()) {
                    sender.sendMessage(Utils.chat("&cSomething went wrong with the transaction"));
                    return true;
                }
            }
            if (sender.hasPermission("valhallakits.allkits") || KitCooldownManager.getInstance().isKitCooldownExpired((Player)sender, kit)) {
                for (Kit.KitEntry entry : kit.getItems().values()) {
                    entry.giveItem((Player)sender);
                }
                for (String cmd : kit.getCommands()) {
                    ValhallaKits.getPlugin().getServer().dispatchCommand((CommandSender)ValhallaKits.getPlugin().getServer().getConsoleSender(), cmd.replace("%player%", sender.getName()));
                }
                KitCooldownManager.getInstance().setKitCooldown((Player)sender, kit);
                sender.sendMessage(Utils.chat(this.status_kit_received));
            } else {
                long cooldown = KitCooldownManager.getInstance().getKitCooldown((Player)sender, kit);
                if (cooldown == -1L) {
                    sender.sendMessage(Utils.chat(this.warning_kit_already_unlocked));
                } else {
                    sender.sendMessage(Utils.chat(this.warning_kit_cooldown.replace("%cooldown%", Utils.toTimeStamp(cooldown, 1000L))));
                }
            }
        } else {
            new PlayerKitSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)sender)).open();
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(KitManager.getRegisteredKits().keySet());
        }
        return null;
    }
}

