/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallakits.ItemStackGSONAdapter;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.ValhallaKits;
import me.athlaeos.valhallakits.hooks.ValhallaHook;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class KitManager {
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(ConfigurationSerializable.class, (Object)new ItemStackGSONAdapter()).setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();
    private static final Map<String, Kit> registeredKits = new HashMap<String, Kit>();

    public static void registerKitsFromFile(File f) {
        HashMap<String, Kit> kits = new HashMap<String, Kit>();
        if (f.exists()) {
            try (BufferedReader recipesReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
                Kit[] collectedKits;
                for (Kit kit : collectedKits = (Kit[])(ValhallaKits.isValhallaHooked() ? ValhallaHook.getValhallaGson() : gson).fromJson((Reader)recipesReader, Kit[].class)) {
                    if (kit == null) continue;
                    kits.put(kit.getName(), kit);
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                ValhallaKits.getPlugin().getServer().getLogger().severe("Could not load recipes file " + f.getPath() + ", " + exception.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        } else {
            ValhallaKits.getPlugin().getServer().getLogger().warning("File " + f.getPath() + " does not exist!");
        }
        registeredKits.putAll(kits);
    }

    public static void saveKits() {
        File f = new File(ValhallaKits.getPlugin().getDataFolder(), "/kits.json");
        if (!f.exists()) {
            ValhallaKits.getPlugin().save("kits.json");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));){
            JsonElement element = (ValhallaKits.isValhallaHooked() ? ValhallaHook.getValhallaGson() : gson).toJsonTree(new ArrayList<Kit>(registeredKits.values()), new TypeToken<ArrayList<Kit>>(){}.getType());
            (ValhallaKits.isValhallaHooked() ? ValhallaHook.getValhallaGson() : gson).toJson(element, (Appendable)writer);
            writer.flush();
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaKits.getPlugin().getServer().getLogger().severe("Could not save recipes file kits.json, " + exception.getMessage());
        }
    }

    public static Map<String, Kit> getRegisteredKits() {
        return registeredKits;
    }
}

