/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class Utils {
    static final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static String oldChat(String message) {
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String chat(String message) {
        char COLOR_CHAR = '\u00a7';
        Matcher matcher = hexPattern.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, COLOR_CHAR + "x" + COLOR_CHAR + group.charAt(0) + COLOR_CHAR + group.charAt(1) + COLOR_CHAR + group.charAt(2) + COLOR_CHAR + group.charAt(3) + COLOR_CHAR + group.charAt(4) + COLOR_CHAR + group.charAt(5));
        }
        return Utils.oldChat(matcher.appendTail(buffer).toString());
    }

    public static String getItemName(ItemStack i) {
        assert (i.getItemMeta() != null);
        String name = i.getItemMeta().hasDisplayName() ? Utils.chat(i.getItemMeta().getDisplayName()) : (i.getItemMeta().hasLocalizedName() ? Utils.chat(i.getItemMeta().getLocalizedName()) : i.getType().toString().toLowerCase().replace("_", " "));
        return name;
    }

    public static String toPascalCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        String allLowercase = s.toLowerCase();
        char c = allLowercase.charAt(0);
        return allLowercase.replaceFirst("" + c, "" + Character.toUpperCase(c));
    }

    public static Map<Integer, ArrayList<ItemStack>> paginateItemStackList(int pageSize, List<ItemStack> allEntries) {
        HashMap<Integer, ArrayList<ItemStack>> pages = new HashMap<Integer, ArrayList<ItemStack>>();
        int stepper = 0;
        int pageNumber = 0;
        while ((double)pageNumber < Math.ceil((double)allEntries.size() / (double)pageSize)) {
            ArrayList<ItemStack> pageEntries = new ArrayList<ItemStack>();
            for (int pageEntry = 0; pageEntry < pageSize && stepper < allEntries.size(); ++pageEntry, ++stepper) {
                pageEntries.add(allEntries.get(stepper));
            }
            pages.put(pageNumber, pageEntries);
            ++pageNumber;
        }
        return pages;
    }

    public static void giveItem(Player p, ItemStack i) {
        HashMap remainder = p.getInventory().addItem(new ItemStack[]{i});
        if (!remainder.isEmpty()) {
            for (ItemStack item : remainder.values()) {
                Item drop = p.getWorld().dropItem(p.getLocation(), item);
                drop.setPickupDelay(0);
                drop.setOwner(p.getUniqueId());
                drop.setThrower(p.getUniqueId());
            }
        }
    }

    public static List<String> separateStringIntoLines(String string, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = string.split(" ");
        if (words.length == 0) {
            return lines;
        }
        StringBuilder sentence = new StringBuilder();
        for (String s : words) {
            if (sentence.length() + s.length() > maxLength || s.contains("-n")) {
                s = s.replace("-n", "");
                lines.add(sentence.toString());
                String previousSentence = sentence.toString();
                sentence = new StringBuilder();
                sentence.append(me.athlaeos.valhallammo.utility.Utils.chat((String)ChatColor.getLastColors((String)me.athlaeos.valhallammo.utility.Utils.chat((String)previousSentence)))).append(s);
                continue;
            }
            if (words[0].equals(s)) {
                sentence.append(s);
                continue;
            }
            sentence.append(" ").append(s);
        }
        lines.add(sentence.toString());
        return lines;
    }

    public static String msToTimestamp(Long ms) {
        Long timeLeft = ms;
        int days = (int)(ms / 86400000L);
        timeLeft = timeLeft % 86400000L;
        int hours = (int)(ms / 3600000L);
        timeLeft = timeLeft % 3600000L;
        int minutes = (int)(timeLeft / 60000L);
        timeLeft = timeLeft % 60000L;
        int seconds = (int)(timeLeft / 1000L);
        timeLeft = timeLeft % 1000L;
        int millis = (int)(timeLeft / 100L);
        String returnString = days > 0 ? days + "d" : (hours > 0 ? hours + "h" : (minutes > 0 ? minutes + "m" : seconds + "." + millis + "s"));
        return returnString;
    }

    public static String toTimeStamp(long ticks, long base) {
        if (ticks == 0L) {
            return "0:00";
        }
        if (ticks < 0L) {
            return "\u221e";
        }
        int hours = (int)Math.floor((double)ticks / (3600.0 * (double)base));
        int minutes = (int)Math.floor((double)(ticks %= base * 3600L) / (60.0 * (double)base));
        int seconds = (int)Math.floor((double)(ticks %= base * 60L) / (double)base);
        if (hours > 0) {
            if (seconds < 10) {
                if (minutes < 10) {
                    return String.format("%d:0%d:0%d", hours, minutes, seconds);
                }
                return String.format("%d:%d:0%d", hours, minutes, seconds);
            }
            if (minutes < 10) {
                return String.format("%d:0%d:%d", hours, minutes, seconds);
            }
            return String.format("%d:%d:%d", hours, minutes, seconds);
        }
        if (seconds < 10) {
            return String.format("%d:0%d", minutes, seconds);
        }
        return String.format("%d:%d", minutes, seconds);
    }

    public static boolean isItemEmptyOrNull(ItemStack i) {
        if (i == null) {
            return true;
        }
        return i.getType().isAir();
    }

    public static double round(double value, int places) {
        if (places < 0) {
            places = 2;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static ItemStack createItemStack(Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(displayName);
        if (lore != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String l : lore) {
                coloredLore.add(Utils.chat(l));
            }
            meta.setLore(coloredLore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static boolean doesPathExist(YamlConfiguration config, String root, String key) {
        ConfigurationSection section = config.getConfigurationSection(root);
        if (section != null) {
            return section.getKeys(false).contains(key);
        }
        return false;
    }

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType().isAir();
    }

    public static String serialize(ItemStack itemStack) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemStack);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ItemStack deserialize(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack i = (ItemStack)dataInput.readObject();
            dataInput.close();
            return i;
        }
        catch (IOException | ClassNotFoundException exception) {
            return null;
        }
    }
}

