/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import me.athlaeos.valhallakits.ValhallaKits;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private String name;
    private File file;
    private YamlConfiguration config;
    private final ValhallaKits plugin = ValhallaKits.getPlugin();

    public Config(String name) {
        this.name = name;
    }

    public Config save() {
        if (this.config == null || this.file == null) {
            return this;
        }
        try {
            if (this.config.getConfigurationSection("").getKeys(true).size() != 0) {
                this.config.save(this.file);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public YamlConfiguration get() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public Config saveDefaultConfig() {
        this.file = new File(this.plugin.getDataFolder(), this.name);
        this.plugin.saveResource(this.name, false);
        return this;
    }

    public Config reload() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.name);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        try {
            InputStreamReader defConfigStream = new InputStreamReader(this.plugin.getResource(this.name), "UTF8");
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                this.config.setDefaults((Configuration)defConfig);
            }
        }
        catch (UnsupportedEncodingException | NullPointerException exception) {
            // empty catch block
        }
        return this;
    }

    public Config copyDefaults(boolean force) {
        this.get().options().copyDefaults(force);
        return this;
    }

    public Config set(String key, Object value) {
        this.get().set(key, value);
        return this;
    }

    public Object get(String key) {
        return this.get().get(key);
    }
}

