/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallakits.Kit;
import me.athlaeos.valhallakits.KitManager;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.ValhallaKitEntry;
import me.athlaeos.valhallakits.ValhallaKits;
import me.athlaeos.valhallakits.menus.KitSelectionMenu;
import me.athlaeos.valhallakits.menus.Menu;
import me.athlaeos.valhallakits.menus.PlayerMenuUtility;
import me.athlaeos.valhallakits.menus.ValhallaKitEntryEditingMenu;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitEditingMenu
extends Menu {
    private final NamespacedKey entryKey = new NamespacedKey((Plugin)ValhallaKits.getPlugin(), "entry_key");
    private final Kit kit;
    private final ItemStack returnToMenuButton = Utils.createItemStack(Material.WRITABLE_BOOK, Utils.chat("&7&lReturn to menu"), null);
    private final ItemStack saveButton = Utils.createItemStack(Material.STRUCTURE_VOID, Utils.chat("&a&lSave Changes"), null);
    private final ItemStack deleteButton = Utils.createItemStack(Material.BARRIER, Utils.chat("&c&lDelete Kit"), null);
    private final ItemStack newEntryButton = Utils.createItemStack(Material.GREEN_STAINED_GLASS_PANE, Utils.chat("&aAdd"), !ValhallaKits.isValhallaHooked() ? Arrays.asList(Utils.chat("&7Drag item from your inventory"), Utils.chat("&7here to add it to the kit")) : Arrays.asList(Utils.chat("&7Drag item from your inventory"), Utils.chat("&7here to add it to the kit without modifiers"), Utils.chat("&7or click regularly to add modifiers also")));

    public KitEditingMenu(PlayerMenuUtility playerMenuUtility, Kit kit) {
        super(playerMenuUtility);
        this.kit = kit.clone();
    }

    @Override
    public String getMenuName() {
        return Utils.chat("&8Editing Kit " + this.kit.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ItemStack clickedItem;
        e.setCancelled(true);
        if (e.getClickedInventory() instanceof PlayerInventory) {
            e.setCancelled(false);
        }
        if ((clickedItem = e.getCurrentItem()) != null) {
            if (clickedItem.equals((Object)this.returnToMenuButton)) {
                new KitSelectionMenu(this.playerMenuUtility).open();
                return;
            }
            if (clickedItem.equals((Object)this.newEntryButton)) {
                String name = UUID.randomUUID().toString();
                for (int i = 0; i < 10 && this.kit.getItems().containsKey(name); ++i) {
                    name = UUID.randomUUID().toString();
                }
                if (ValhallaKits.isValhallaHooked()) {
                    if (!Utils.isItemEmptyOrNull(e.getCursor())) {
                        this.kit.getItems().put(name, new ValhallaKitEntry(name, e.getCursor().clone(), new ArrayList<DynamicItemModifier>()));
                    } else {
                        new ValhallaKitEntryEditingMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)this.playerMenuUtility.getOwner()), this.kit, new ValhallaKitEntry(name, Utils.createItemStack(Material.WOODEN_SWORD, Utils.chat("&r&fPlace your own custom kit item here :)"), null), new ArrayList<DynamicItemModifier>())).open();
                    }
                } else if (!Utils.isItemEmptyOrNull(e.getCursor())) {
                    this.kit.getItems().put(name, new Kit.KitEntry(name, e.getCursor().clone()));
                }
            } else {
                if (clickedItem.equals((Object)this.saveButton)) {
                    KitManager.getRegisteredKits().put(this.kit.getName(), this.kit);
                    new KitSelectionMenu(this.playerMenuUtility).open();
                    return;
                }
                if (clickedItem.equals((Object)this.deleteButton)) {
                    KitManager.getRegisteredKits().remove(this.kit.getName());
                    new KitSelectionMenu(this.playerMenuUtility).open();
                    return;
                }
                ItemMeta meta = clickedItem.getItemMeta();
                assert (meta != null);
                if (meta.getPersistentDataContainer().has(this.entryKey, PersistentDataType.STRING)) {
                    String value = (String)meta.getPersistentDataContainer().get(this.entryKey, PersistentDataType.STRING);
                    Kit.KitEntry entry = this.kit.getItems().get(value);
                    if (entry == null) {
                        this.playerMenuUtility.getOwner().sendMessage(Utils.chat("&cItem has been removed"));
                    } else if (ValhallaKits.isValhallaHooked()) {
                        new ValhallaKitEntryEditingMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)this.playerMenuUtility.getOwner()), this.kit, entry).open();
                    } else {
                        this.kit.getItems().remove(value);
                    }
                }
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        ArrayList<ItemStack> entryButtons = new ArrayList<ItemStack>();
        for (Kit.KitEntry entry : this.kit.getItems().values().stream().limit(45L).collect(Collectors.toSet())) {
            List buttonLore;
            ItemStack button = entry.getItem().clone();
            ItemMeta buttonMeta = button.getItemMeta();
            if (buttonMeta == null) continue;
            List list = buttonLore = buttonMeta.getLore() != null ? buttonMeta.getLore() : new ArrayList();
            if (ValhallaKits.isValhallaHooked()) {
                buttonLore.add(Utils.chat("&8&m                                 "));
                buttonLore.add(Utils.chat("&fModifiers:"));
                ValhallaKitEntry asValhallaEntry = entry instanceof ValhallaKitEntry ? (ValhallaKitEntry)entry : new ValhallaKitEntry(entry.getId(), entry.getItem(), new ArrayList<DynamicItemModifier>());
                for (DynamicItemModifier modifier : asValhallaEntry.getModifiers()) {
                    buttonLore.addAll(StringUtils.separateStringIntoLines((String)Utils.chat("&f> " + modifier.getActiveDescription()), (int)40));
                }
            }
            buttonMeta.setLore(buttonLore);
            buttonMeta.getPersistentDataContainer().set(this.entryKey, PersistentDataType.STRING, (Object)entry.getId());
            button.setItemMeta(buttonMeta);
            entryButtons.add(button);
        }
        if (entryButtons.size() < 45) {
            entryButtons.add(this.newEntryButton);
        }
        this.inventory.addItem(entryButtons.toArray(new ItemStack[0]));
        this.inventory.setItem(45, this.deleteButton);
        this.inventory.setItem(49, this.returnToMenuButton);
        this.inventory.setItem(53, this.saveButton);
    }
}

