/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallakits.menus;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallakits.Utils;
import me.athlaeos.valhallakits.menus.Menu;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;

public class MenuListener
implements Listener {
    private static final Map<UUID, Menu> activeMenus = new HashMap<UUID, Menu>();

    public static void setActiveMenu(Player p, Menu menu) {
        activeMenus.put(p.getUniqueId(), menu);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMenuOpen(InventoryOpenEvent e) {
        if (!e.getPlayer().isSleeping()) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSleep(PlayerBedEnterEvent e) {
        e.getPlayer().closeInventory();
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent e) {
        Menu activeMenu = activeMenus.get(e.getWhoClicked().getUniqueId());
        if (activeMenu != null && e.getInventory().equals((Object)activeMenu.getInventory())) {
            activeMenu.handleMenu(e);
        }
    }

    @EventHandler
    public void onMenuDrag(InventoryDragEvent e) {
        Menu activeMenu = activeMenus.get(e.getWhoClicked().getUniqueId());
        if (activeMenu != null && e.getInventory().equals((Object)activeMenu.getInventory()) && !Utils.isEmpty(e.getCursor())) {
            activeMenu.handleMenu(e);
        }
    }

    @EventHandler
    public void onMenuClose(InventoryCloseEvent e) {
        Menu activeMenu = activeMenus.get(e.getPlayer().getUniqueId());
        if (activeMenu != null && e.getInventory().equals((Object)activeMenu.getInventory())) {
            activeMenu.onClose();
        }
    }
}

