/*
 * Decompiled with CFR 0.152.
 */
package Skin.Management.skin_management.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;

@Environment(value=EnvType.CLIENT)
public class ServerApiClient {
    private static final int TIMEOUT_MS = 15000;
    private static final ExecutorService EXEC = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "ServerApiClient-Worker");
        t.setDaemon(true);
        return t;
    });
    private static volatile boolean PROD = false;
    private static volatile String BASE_DEV = "http://185.84.161.236:2555";
    private static volatile String BASE_PROD = "http://185.84.161.236:2555";
    private static volatile String BASE_OVERRIDE = null;
    private static volatile String PATH_UPLOAD = "/upload";
    private static volatile String PATH_SELECT = "/select";
    private static volatile String PATH_SELECTED = "/selected";
    private static volatile String PATH_PUBLIC = "/public/";
    private static volatile String AUTH_TOKEN = null;

    public static void setProd(boolean prod) {
        PROD = prod;
    }

    public static void setBase(String baseUrl) {
        BASE_OVERRIDE = baseUrl;
    }

    public static void setAuthToken(String bearerToken) {
        AUTH_TOKEN = bearerToken;
    }

    public static void setPaths(String upload, String select, String selected, String publicPath) {
        if (upload != null) {
            PATH_UPLOAD = upload;
        }
        if (select != null) {
            PATH_SELECT = select;
        }
        if (selected != null) {
            PATH_SELECTED = selected;
        }
        if (publicPath != null) {
            PATH_PUBLIC = publicPath.endsWith("/") ? publicPath : publicPath + "/";
        }
    }

    private static String userAgent() {
        return "skin_management/ServerApiClient";
    }

    private static String base() {
        if (BASE_OVERRIDE != null && !BASE_OVERRIDE.isBlank()) {
            return ServerApiClient.trimSlash(BASE_OVERRIDE);
        }
        return PROD ? ServerApiClient.trimSlash(BASE_PROD) : ServerApiClient.trimSlash(BASE_DEV);
    }

    private static String trimSlash(String s) {
        int n;
        if (s == null) {
            return "";
        }
        for (n = s.length(); n > 0 && s.charAt(n - 1) == '/'; --n) {
        }
        return n == s.length() ? s : s.substring(0, n);
    }

    private static String join(String a, String b) {
        if (b == null || b.isBlank()) {
            return a;
        }
        if (b.startsWith("/")) {
            return a + b;
        }
        return a + "/" + b;
    }

    private static boolean isHttp(String s) {
        return s != null && (s.startsWith("http://") || s.startsWith("https://"));
    }

    private static HttpURLConnection open(String method, String pathOrUrl, String contentType) throws IOException {
        String url = ServerApiClient.isHttp(pathOrUrl) ? pathOrUrl : ServerApiClient.join(ServerApiClient.base(), pathOrUrl);
        HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
        c.setInstanceFollowRedirects(true);
        c.setConnectTimeout(15000);
        c.setReadTimeout(15000);
        c.setRequestMethod(method);
        c.setRequestProperty("User-Agent", ServerApiClient.userAgent());
        if (contentType != null) {
            c.setRequestProperty("Content-Type", contentType);
        }
        if (AUTH_TOKEN != null && !AUTH_TOKEN.isBlank()) {
            c.setRequestProperty("Authorization", "Bearer " + AUTH_TOKEN);
        }
        if ("POST".equals(method) || "PUT".equals(method)) {
            c.setDoOutput(true);
        }
        return c;
    }

    public static void uploadSkinAsync(File file, UUID playerUuid, boolean isSlim, ProgressListener cb) {
        CompletableFuture.runAsync(() -> {
            try {
                String boundary = "----SM-" + System.nanoTime();
                HttpURLConnection c = ServerApiClient.open("POST", PATH_UPLOAD, "multipart/form-data; boundary=" + boundary);
                long total = file.length();
                cb.onStart(total);
                try (OutputStream out0 = c.getOutputStream();
                     CountingOutputStream out = new CountingOutputStream(out0, total, cb);
                     PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8), true);){
                    w.append("--").append(boundary).append("\r\n");
                    if (playerUuid != null) {
                        w.append("Content-Disposition: form-data; name=\"uuid\"").append("\r\n\r\n");
                        w.append(playerUuid.toString()).append("\r\n");
                    }
                    w.append("--").append(boundary).append("\r\n");
                    w.append("Content-Disposition: form-data; name=\"slim\"").append("\r\n\r\n");
                    w.append(isSlim ? "true" : "false").append("\r\n");
                    w.append("--").append(boundary).append("\r\n");
                    w.append("Content-Disposition: form-data; name=\"file\"; filename=\"skin.png\"").append("\r\n");
                    w.append("Content-Type: image/png").append("\r\n\r\n");
                    w.flush();
                    try (FileInputStream in = new FileInputStream(file);){
                        int r;
                        byte[] buf = new byte[8192];
                        while ((r = ((InputStream)in).read(buf)) != -1) {
                            out.write(buf, 0, r);
                        }
                    }
                    out.flush();
                    w.append("\r\n").flush();
                    w.append("--").append(boundary).append("--").append("\r\n");
                    w.flush();
                }
                int code = c.getResponseCode();
                String body = ServerApiClient.readBody(c);
                if (code / 100 == 2) {
                    String id = ServerApiClient.jsonStr(body, "id");
                    if (id == null || id.isEmpty()) {
                        String url = ServerApiClient.jsonStr(body, "url");
                        id = url != null && !url.isEmpty() ? url : (body != null ? body.trim() : "ok");
                    }
                    cb.onDone(true, id);
                } else {
                    cb.onDone(false, (String)(body == null || body.isBlank() ? "HTTP " + code : body));
                }
            }
            catch (Exception e) {
                cb.onDone(false, e.getMessage());
            }
        }, EXEC);
    }

    public static void selectSkin(UUID playerUuid, String skinIdOrUrl) {
        CompletableFuture.runAsync(() -> {
            try {
                HttpURLConnection c = ServerApiClient.open("POST", PATH_SELECT, "application/json; charset=utf-8");
                String body = "{\"uuid\":\"" + String.valueOf(playerUuid) + "\",\"skin\":\"" + ServerApiClient.escJson(skinIdOrUrl) + "\"}";
                try (OutputStream out = c.getOutputStream();){
                    out.write(body.getBytes(StandardCharsets.UTF_8));
                }
                int code = c.getResponseCode();
                if (code / 100 != 2) {
                    ServerApiClient.readBody(c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, EXEC);
    }

    public static CompletableFuture<SelectedSkin> fetchSelectedAsync(UUID playerUuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String id;
                String q = PATH_SELECTED.contains("?") ? PATH_SELECTED + "&uuid=" + String.valueOf(playerUuid) : PATH_SELECTED + "?uuid=" + String.valueOf(playerUuid);
                HttpURLConnection c = ServerApiClient.open("GET", q, null);
                int code = c.getResponseCode();
                String body = ServerApiClient.readBody(c);
                if (code / 100 != 2) {
                    throw new IOException("HTTP " + code + ": " + body);
                }
                String url = ServerApiClient.jsonStr(body, "url");
                if ((url == null || url.isBlank()) && (id = ServerApiClient.jsonStr(body, "id")) != null && !id.isBlank()) {
                    url = ServerApiClient.endpointPublicPng(id);
                }
                boolean slim = ServerApiClient.jsonBool(body, "slim", false);
                if (url == null || url.isBlank()) {
                    return null;
                }
                return new SelectedSkin(url, slim);
            }
            catch (Exception e) {
                return null;
            }
        }, EXEC);
    }

    public static CompletableFuture<class_1043> downloadTextureAsync(String urlOrPath) {
        return CompletableFuture.supplyAsync(() -> {
            class_1043 class_10432;
            block9: {
                HttpURLConnection c = ServerApiClient.open("GET", urlOrPath, null);
                int code = c.getResponseCode();
                if (code / 100 != 2) {
                    throw new IOException("HTTP " + code);
                }
                InputStream in = c.getInputStream();
                try {
                    class_1011 image = class_1011.method_4309((InputStream)in);
                    class_10432 = new class_1043(image);
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                in.close();
            }
            return class_10432;
        }, EXEC);
    }

    public static String endpointPublicPng(String id) {
        if (id == null) {
            return null;
        }
        if (id.endsWith(".png")) {
            return PATH_PUBLIC.startsWith("/") ? ServerApiClient.join(ServerApiClient.base(), PATH_PUBLIC + id) : ServerApiClient.join(ServerApiClient.base(), "/" + PATH_PUBLIC + id);
        }
        return PATH_PUBLIC.startsWith("/") ? ServerApiClient.join(ServerApiClient.base(), PATH_PUBLIC + id + ".png") : ServerApiClient.join(ServerApiClient.base(), "/" + PATH_PUBLIC + id + ".png");
    }

    public static String ping() {
        try {
            HttpURLConnection c = ServerApiClient.open("GET", "/", null);
            c.getResponseCode();
            String body = ServerApiClient.readBody(c);
            return body == null || body.isBlank() ? "OK" : body;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static CompletableFuture<Boolean> pingAsyncOk() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpURLConnection c = ServerApiClient.open("GET", "/", null);
                int code = c.getResponseCode();
                return code / 100 == 2;
            }
            catch (Exception e) {
                return false;
            }
        }, EXEC);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readBody(HttpURLConnection c) {
        try (InputStream in = c.getResponseCode() / 100 == 2 ? c.getInputStream() : c.getErrorStream();){
            int r;
            if (in == null) {
                String string2 = null;
                return string2;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((r = in.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            String string = out.toString(StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String escJson(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch < ' ') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String jsonStr(String body, String key) {
        if (body == null) {
            return null;
        }
        String pat = "\"" + key + "\"";
        int i = body.indexOf(pat);
        if (i < 0) {
            return null;
        }
        if ((i = body.indexOf(58, i)) < 0) {
            return null;
        }
        int q1 = body.indexOf(34, i + 1);
        if (q1 < 0) {
            return null;
        }
        int q2 = body.indexOf(34, q1 + 1);
        if (q2 < 0) {
            return null;
        }
        return body.substring(q1 + 1, q2);
    }

    private static boolean jsonBool(String body, String key, boolean def) {
        int j;
        if (body == null) {
            return def;
        }
        String pat = "\"" + key + "\"";
        int i = body.indexOf(pat);
        if (i < 0) {
            return def;
        }
        if ((i = body.indexOf(58, i)) < 0) {
            return def;
        }
        for (j = i + 1; j < body.length() && Character.isWhitespace(body.charAt(j)); ++j) {
        }
        if (j >= body.length()) {
            return def;
        }
        if (body.regionMatches(true, j, "true", 0, 4)) {
            return true;
        }
        if (body.regionMatches(true, j, "false", 0, 5)) {
            return false;
        }
        if (body.regionMatches(true, j, "1", 0, 1)) {
            return true;
        }
        if (body.regionMatches(true, j, "0", 0, 1)) {
            return false;
        }
        return def;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ProgressListener {
        default public void onStart(long totalBytes) {
        }

        default public void onProgress(long sent, long total) {
        }

        default public void onDone(boolean ok, String msgOrSkinId) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SelectedSkin(String url, boolean slim) {
    }

    @Environment(value=EnvType.CLIENT)
    static final class CountingOutputStream
    extends OutputStream {
        final OutputStream delegate;
        final long total;
        final ProgressListener cb;
        long sent = 0L;

        CountingOutputStream(OutputStream delegate, long total, ProgressListener cb) {
            this.delegate = delegate;
            this.total = total;
            this.cb = cb;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++this.sent;
            this.cb.onProgress(this.sent, this.total);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.sent += (long)len;
            this.cb.onProgress(this.sent, this.total);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

