/*
 * Decompiled with CFR 0.152.
 */
package Skin.Management.skin_management.client;

import Skin.Management.skin_management.client.ModSounds;
import Skin.Management.skin_management.client.ServerApiClient;
import Skin.Management.skin_management.client.SkinManagerClient;
import Skin.Management.skin_management.client.SkinUploadScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class SkinManagementClient
implements ClientModInitializer {
    public static final String MODID = "skin_management";
    private static class_304 openUiKey;
    private static int tickCounter;
    private static final int ENSURE_INTERVAL_TICKS = 20;
    private static final int ENSURE_LIMIT_PER_PASS = 16;

    public void onInitializeClient() {
        ModSounds.register();
        SkinManagerClient.setRefreshIntervalMs(1000L);
        openUiKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.skin_management.open_ui", class_3675.class_307.field_1668, 75, "key.categories.skin_management"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openUiKey.method_1436()) {
                SkinManagementClient.openNow();
            }
            if (client.field_1687 != null && ++tickCounter % 20 == 0) {
                int count = 0;
                for (class_742 p : client.field_1687.method_18456()) {
                    if (p == null) continue;
                    SkinManagerClient.ensureFetch(p.method_5667());
                    if (++count < 16) continue;
                    break;
                }
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(() -> {
            try {
                ServerApiClient.startSse(evt -> {
                    if (evt != null && evt.uuid != null) {
                        client.execute(() -> {
                            if (evt.slim != null) {
                                SkinManagerClient.setSlim(evt.uuid, evt.slim);
                            }
                            SkinManagerClient.forceFetch(evt.uuid);
                        });
                    }
                });
                if (client.field_1724 != null) {
                    SkinManagerClient.fetchAndApplyFor(client.field_1724.method_5667());
                }
                SkinUploadScreen.Toasts.ConnectionToast t = SkinUploadScreen.Toasts.connectionTrans("title.skin_cloud", "toast.cloud.checking");
                ServerApiClient.pingAsyncOk().thenAccept(ok -> client.execute(() -> t.complete((boolean)ok, class_2561.method_43471((String)(ok != false ? "toast.cloud.connected" : "toast.cloud.failed")).getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> client.execute(() -> {
            try {
                SkinManagerClient.clearAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ServerApiClient.stopSse();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        System.out.println("[skin_management] client initialized, keybind registered.");
    }

    public static void openNow() {
        class_310 mc = class_310.method_1551();
        mc.execute(() -> mc.method_1507((class_437)new SkinUploadScreen()));
    }

    static {
        tickCounter = 0;
    }
}

