/*
 * Decompiled with CFR 0.152.
 */
package Skin.Management.skin_management.client;

import Skin.Management.skin_management.client.ServerApiClient;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public final class SkinManagerClient {
    private static final String MODID = "skin_management";
    private static final Map<UUID, class_2960> CACHE = new ConcurrentHashMap<UUID, class_2960>();
    private static final Map<UUID, Boolean> SLIM = new ConcurrentHashMap<UUID, Boolean>();
    private static final Set<UUID> INFLIGHT = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> LAST_CHECK = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, String> SELECT_URL = new ConcurrentHashMap<UUID, String>();
    private static final Map<UUID, Boolean> PREFERRED_SLIM = new ConcurrentHashMap<UUID, Boolean>();
    private static volatile long REFRESH_INTERVAL_MS = 5000L;
    private static final ExecutorService EXEC = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "SkinManagerClient");
        t.setDaemon(true);
        return t;
    });

    public static void setRefreshIntervalMs(long ms) {
        REFRESH_INTERVAL_MS = Math.max(1000L, ms);
    }

    private SkinManagerClient() {
    }

    private static class_2960 idFor(UUID u) {
        return new class_2960(MODID, "remote/" + u.toString().replace("-", ""));
    }

    public static class_2960 getOrFetch(class_742 player) {
        if (player == null) {
            return null;
        }
        UUID u = player.method_5667();
        class_2960 id = CACHE.get(u);
        if (id == null) {
            SkinManagerClient.fetchAndApplyFor(u);
            return null;
        }
        if (SkinManagerClient.shouldPoll(u)) {
            SkinManagerClient.fetchAndApplyFor(u);
        }
        return id;
    }

    public static class_2960 getOrFetch(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        class_2960 id = CACHE.get(uuid);
        if (id != null) {
            return id;
        }
        SkinManagerClient.fetchAndApplyFor(uuid);
        return null;
    }

    public static class_2960 getCached(UUID uuid) {
        return uuid == null ? null : CACHE.get(uuid);
    }

    public static Boolean isSlimOrNull(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Boolean v = SLIM.get(uuid);
        if (v != null) {
            return v;
        }
        Boolean pref = PREFERRED_SLIM.get(uuid);
        if (pref != null) {
            return pref;
        }
        return null;
    }

    public static boolean isSlim(UUID uuid, boolean defVal) {
        Boolean v = SLIM.get(uuid);
        if (v != null) {
            return v;
        }
        Boolean pref = PREFERRED_SLIM.get(uuid);
        if (pref != null) {
            return pref;
        }
        return defVal;
    }

    public static void setSlim(UUID uuid, boolean slim) {
        if (uuid != null) {
            SLIM.put(uuid, slim);
            PREFERRED_SLIM.put(uuid, slim);
        }
    }

    public static void ensureFetch(UUID uuid) {
        if (uuid == null) {
            return;
        }
        if (!CACHE.containsKey(uuid) || SkinManagerClient.shouldPoll(uuid)) {
            SkinManagerClient.fetchAndApplyFor(uuid);
        }
    }

    public static void forceFetch(UUID uuid) {
        if (uuid == null) {
            return;
        }
        LAST_CHECK.remove(uuid);
        SkinManagerClient.fetchAndApplyFor(uuid);
    }

    private static boolean shouldPoll(UUID uuid) {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = LAST_CHECK.getOrDefault(uuid, 0L).longValue()) >= REFRESH_INTERVAL_MS) {
            LAST_CHECK.put(uuid, now);
            return true;
        }
        return false;
    }

    public static void refresh(UUID uuid) {
        class_1060 tm = class_310.method_1551().method_1531();
        class_2960 id = CACHE.remove(uuid);
        if (id != null) {
            tm.method_4615(id);
        }
        SELECT_URL.remove(uuid);
        SkinManagerClient.fetchAndApplyFor(uuid);
    }

    public static void fetchAndApplyFor(UUID uuid) {
        if (uuid == null) {
            return;
        }
        if (!INFLIGHT.add(uuid)) {
            return;
        }
        CompletableFuture<ServerApiClient.SelectedSkin> selected = ServerApiClient.fetchSelectedAsync(uuid);
        ((CompletableFuture)selected.thenCompose(sel -> {
            if (sel == null) {
                return CompletableFuture.completedFuture(null);
            }
            SLIM.put(uuid, sel.slim());
            String prev = SELECT_URL.get(uuid);
            if (prev != null && prev.equals(sel.url())) {
                return CompletableFuture.completedFuture(null);
            }
            SELECT_URL.put(uuid, sel.url());
            return ServerApiClient.downloadTextureAsync(sel.url());
        })).whenCompleteAsync((tex, err) -> {
            INFLIGHT.remove(uuid);
            if (err != null || tex == null) {
                return;
            }
            class_310 mc = class_310.method_1551();
            mc.execute(() -> {
                class_2960 id = SkinManagerClient.idFor(uuid);
                class_1060 tm = mc.method_1531();
                tm.method_4615(id);
                tm.method_4616(id, (class_1044)tex);
                CACHE.put(uuid, id);
            });
        }, (Executor)EXEC);
    }

    public static void clearAll() {
        class_310 mc = class_310.method_1551();
        mc.execute(() -> {
            class_1060 tm = mc.method_1531();
            for (class_2960 id : CACHE.values()) {
                tm.method_4615(id);
            }
            CACHE.clear();
            SLIM.clear();
            INFLIGHT.clear();
            LAST_CHECK.clear();
            SELECT_URL.clear();
            PREFERRED_SLIM.clear();
        });
    }
}

