/*
 * Decompiled with CFR 0.152.
 */
package Skin.Management.skin_management.client;

import Skin.Management.skin_management.client.ModSounds;
import Skin.Management.skin_management.client.ServerApiClient;
import Skin.Management.skin_management.client.SkinManagerClient;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SkinUploadScreen
extends class_437 {
    private static final float UI_SCALE = 1.0f;
    private static final float TOP_YR = 0.2f;
    private static final float BOT_YR = 0.82f;
    private static final int BOX_PAD = 12;
    private static final int DASH_COLOR = -855638017;
    private static final String MOD_ID = "skin_management";
    private File selectedFile;
    private class_4286 slimToggle;
    private class_4185 chooseButton;
    private class_4185 uploadButton;
    private class_2960 previewId;
    private class_1043 previewTex;
    private int previewW;
    private int previewH;
    private int zoneTop;
    private int zoneBot;
    private int dropX;
    private int dropY;
    private int dropW;
    private int dropH;
    private int controlsY;
    private int modelY;
    private static final String HEX = "0123456789abcdef";

    private int u(int px) {
        return Math.max(1, Math.round((float)px * 1.0f));
    }

    public SkinUploadScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.skin_management.title"));
    }

    protected void method_25426() {
        this.zoneTop = Math.round((float)this.field_22790 * 0.2f);
        this.zoneBot = Math.round((float)this.field_22790 * 0.82f);
        if (this.zoneBot <= this.zoneTop + this.u(140)) {
            this.zoneBot = this.zoneTop + this.u(140);
        }
        int rowH = this.u(20);
        int gap = this.u(16);
        int marginBetween = this.u(10);
        int btnW = Math.max(this.u(160), this.field_22789 / 6);
        int bandTop = this.zoneTop + this.u(12);
        int bandBot = this.zoneBot - this.u(12);
        Objects.requireNonNull(this.field_22793);
        int fontH = 9;
        int reserveBelow = rowH + this.u(6) + fontH;
        int availH = bandBot - bandTop - reserveBelow - marginBetween;
        int size = Math.min(availH, (int)((float)this.field_22789 * 0.68f));
        this.dropW = this.dropH = (size = Math.max(this.u(140), size));
        this.dropX = (this.field_22789 - size) / 2;
        this.dropY = bandTop + (availH - size) / 2;
        this.controlsY = this.dropY + this.dropH + marginBetween;
        int checkBoxSize = this.u(20);
        int labelGap = this.u(6);
        int labelW = this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"screen.skin_management.slim_model"));
        int midW = checkBoxSize + labelGap + labelW;
        int centerX = this.field_22789 / 2;
        int midX = centerX - midW / 2;
        int leftX = midX - gap - btnW;
        int rightX = midX + midW + gap;
        this.method_37067();
        this.chooseButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.skin_management.button.select_png"), b -> this.openFilePicker()).method_46434(leftX, this.controlsY, btnW, rowH).method_46431();
        this.method_37063((class_364)this.chooseButton);
        this.slimToggle = new class_4286(midX, this.controlsY, midW, rowH, (class_2561)class_2561.method_43471((String)"screen.skin_management.slim_model"), false);
        this.method_37063((class_364)this.slimToggle);
        this.uploadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.skin_management.button.upload"), b -> this.doUpload()).method_46434(rightX, this.controlsY, btnW, rowH).method_46431();
        this.uploadButton.field_22763 = this.selectedFile != null;
        this.method_37063((class_364)this.uploadButton);
        this.modelY = this.controlsY + rowH + this.u(6);
    }

    public void method_25410(class_310 c, int w, int h) {
        super.method_25410(c, w, h);
        this.method_25426();
    }

    public void method_25419() {
        this.disposePreview();
        super.method_25419();
    }

    private void disposePreview() {
        if (this.previewId != null) {
            class_310.method_1551().method_1531().method_4615(this.previewId);
            this.previewId = null;
        }
        this.previewTex = null;
        this.previewH = 0;
        this.previewW = 0;
    }

    private void setSelectedFile(File f) {
        if (f == null) {
            return;
        }
        String name = f.getName().toLowerCase(Locale.ROOT);
        if (!name.endsWith(".png")) {
            SkinUploadScreen.toastErrorKey("toast.error.not_png", new Object[0]);
            try {
                ModSounds.play(ModSounds.UI_ERROR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try (FileInputStream in = new FileInputStream(f);){
            boolean inRange;
            class_1011 img = class_1011.method_4309((InputStream)in);
            int w = img.method_4307();
            int h = img.method_4323();
            boolean square = w == h;
            boolean pow2 = (w & w - 1) == 0;
            boolean bl = inRange = w >= 64 && w <= 8192;
            if (!(square && pow2 && inRange)) {
                img.close();
                SkinUploadScreen.toastErrorKey("toast.error.invalid_dimensions", new Object[0]);
                try {
                    ModSounds.play(ModSounds.UI_ERROR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.disposePreview();
            this.previewTex = new class_1043(img);
            this.previewTex.method_4527(false, false);
            this.previewW = w;
            this.previewH = h;
            this.previewId = new class_2960(MOD_ID, "preview/" + System.nanoTime());
            class_310.method_1551().method_1531().method_4616(this.previewId, (class_1044)this.previewTex);
            this.selectedFile = f;
            this.uploadButton.field_22763 = true;
            SkinUploadScreen.toastInfoKey("toast.file.selected", f.getName());
            try {
                ModSounds.play(ModSounds.UI_UPLOAD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            SkinUploadScreen.toastErrorKey("toast.error.read_failed", new Object[0]);
            try {
                ModSounds.play(ModSounds.UI_ERROR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void openFilePicker() {
        try {
            EventQueue.invokeLater(() -> {
                try {
                    File f;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(class_2561.method_43471((String)"screen.skin_management.button.select_png").getString());
                    chooser.setFileFilter(new FileNameExtensionFilter("PNG Images", "png"));
                    int res = chooser.showOpenDialog(null);
                    if (res == 0 && (f = chooser.getSelectedFile()) != null) {
                        class_310.method_1551().execute(() -> this.setSelectedFile(f));
                    }
                }
                catch (Throwable t) {
                    class_310.method_1551().execute(this::openFolderFallback);
                }
            });
        }
        catch (Throwable t) {
            this.openFolderFallback();
        }
    }

    private void openFolderFallback() {
        File dropDir = new File(class_310.method_1551().field_1697, "skin_uploads");
        if (!dropDir.exists() && !dropDir.mkdirs()) {
            SkinUploadScreen.toastErrorKey("toast.error.create_folder_failed", new Object[0]);
            return;
        }
        class_156.method_668().method_672(dropDir);
        SkinUploadScreen.toastInfoKey("toast.folder.opened", new Object[0]);
    }

    private void doUpload() {
        if (this.selectedFile == null) {
            SkinUploadScreen.toastErrorKey("toast.error.read_failed", new Object[0]);
            try {
                ModSounds.play(ModSounds.UI_ERROR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        final boolean isSlim = this.slimToggle.method_20372();
        final class_310 mc = class_310.method_1551();
        final Toasts.UploadToast toast = Toasts.showTrans("toast.upload.title", "toast.upload.preparing", new Object[0]);
        try {
            ModSounds.play(ModSounds.UI_UPLOAD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mc.method_1507(null);
        UUID playerUuid = null;
        try {
            if (mc.field_1724 != null) {
                playerUuid = mc.field_1724.method_5667();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerApiClient.uploadSkinAsync(this.selectedFile, playerUuid, isSlim, new ServerApiClient.ProgressListener(){
            final /* synthetic */ SkinUploadScreen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onStart(long totalBytes) {
                mc.execute(() -> toast.update(0.0f, class_2561.method_43469((String)"toast.upload.start", (Object[])new Object[]{SkinUploadScreen.human(totalBytes)}).getString()));
            }

            @Override
            public void onProgress(long sent, long total) {
                float p = total > 0L ? (float)sent / (float)total : 0.0f;
                mc.execute(() -> toast.update(p, (int)(p * 100.0f) + "%"));
            }

            @Override
            public void onDone(boolean ok, String msgOrSkinId) {
                mc.execute(() -> {
                    toast.complete(ok, class_2561.method_43471((String)(ok ? "toast.upload.success" : "toast.upload.failed")).getString());
                    if (ok) {
                        try {
                            ModSounds.play(ModSounds.UI_COMPLETE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            class_746 player = mc2.field_1724;
                            if (player != null) {
                                ServerApiClient.selectSkin(player.method_5667(), msgOrSkinId);
                                SkinManagerClient.setSlim(player.method_5667(), isSlim);
                                SkinManagerClient.refresh(player.method_5667());
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            ModSounds.play(ModSounds.UI_ERROR);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Toasts.error((class_2561)class_2561.method_43471((String)"title.skin_management"), (class_2561)class_2561.method_43470((String)(msgOrSkinId != null ? msgOrSkinId : class_2561.method_43471((String)"toast.upload.failed").getString())));
                    }
                });
            }
        });
    }

    public void method_29638(List<Path> paths) {
        for (Path p : paths) {
            File f = p.toFile();
            if (!f.getName().toLowerCase(Locale.ROOT).endsWith(".png")) continue;
            this.setSelectedFile(f);
            return;
        }
        SkinUploadScreen.toastErrorKey("toast.error.drag_not_png", new Object[0]);
        try {
            ModSounds.play(ModSounds.UI_ERROR);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, 0x22000000);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.skin_management.header"), this.field_22789 / 2, this.u(12), -1);
        ctx.method_25294(this.dropX, this.dropY, this.dropX + this.dropW, this.dropY + this.dropH, 0x22000000);
        this.dashedRect(ctx, this.dropX, this.dropY, this.dropW, this.dropH, -855638017, this.u(8), this.u(8), this.u(2));
        if (this.previewId != null) {
            float maxW = this.dropW - this.u(20);
            float maxH = this.dropH - this.u(20);
            float scale = Math.min(maxW / (float)this.previewW, maxH / (float)this.previewH);
            int drawW = Math.round((float)this.previewW * scale);
            int drawH = Math.round((float)this.previewH * scale);
            int px = this.dropX + (this.dropW - drawW) / 2;
            int py = this.dropY + (this.dropH - drawH) / 2;
            ctx.method_44379(this.dropX + 1, this.dropY + 1, this.dropX + this.dropW - 1, this.dropY + this.dropH - 1);
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)px, (float)py, 0.0f);
            ctx.method_51448().method_22905(scale, scale, 1.0f);
            ctx.method_25290(this.previewId, 0, 0, 0.0f, 0.0f, this.previewW, this.previewH, this.previewW, this.previewH);
            ctx.method_51448().method_22909();
            ctx.method_44380();
        } else {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.skin_management.drop_hint"), this.dropX + this.dropW / 2, this.dropY + this.dropH / 2 - this.u(4), -1);
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
        class_5250 modeTxt = class_2561.method_43471((String)(this.slimToggle.method_20372() ? "screen.skin_management.mode.slim" : "screen.skin_management.mode.classic"));
        class_5250 line = class_2561.method_43469((String)"screen.skin_management.mode.label", (Object[])new Object[]{modeTxt});
        ctx.method_27534(this.field_22793, (class_2561)line, this.field_22789 / 2, this.modelY, -2236963);
        String __qteamWatermark = "\u00a9 2025 Q Team Studio";
        int __qteamTw = this.field_22793.method_1727("\u00a9 2025 Q Team Studio");
        int __qteamX = this.field_22789 - __qteamTw - 6;
        Objects.requireNonNull(this.field_22793);
        int __qteamY = this.field_22790 - 9 - 6;
        ctx.method_51433(this.field_22793, "\u00a9 2025 Q Team Studio", __qteamX, __qteamY, -1, true);
    }

    private void dashedRect(class_332 ctx, int x, int y, int w, int h, int color, int dash, int gap, int thick) {
        int len;
        int i;
        for (i = 0; i < w; i += dash + gap) {
            len = Math.min(dash, w - i);
            ctx.method_25294(x + i, y, x + i + len, y + thick, color);
            ctx.method_25294(x + i, y + h - thick, x + i + len, y + h, color);
        }
        for (i = 0; i < h; i += dash + gap) {
            len = Math.min(dash, h - i);
            ctx.method_25294(x, y + i, x + thick, y + i + len, color);
            ctx.method_25294(x + w - thick, y + i, x + w, y + i + len, color);
        }
    }

    private static void toastInfoKey(String key, Object ... args) {
        Toasts.info((class_2561)class_2561.method_43471((String)"title.skin_management"), (class_2561)class_2561.method_43469((String)key, (Object[])args));
    }

    private static void toastErrorKey(String key, Object ... args) {
        Toasts.error((class_2561)class_2561.method_43471((String)"title.skin_management"), (class_2561)class_2561.method_43469((String)key, (Object[])args));
    }

    private static String human(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format(Locale.ROOT, "%.1f KB", Float.valueOf((float)bytes / 1024.0f));
        }
        return String.format(Locale.ROOT, "%.1f MB", Float.valueOf((float)bytes / 1048576.0f));
    }

    static String sha256(File f) {
        String string;
        FileInputStream in = new FileInputStream(f);
        try {
            int r;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buf = new byte[8192];
            while ((r = in.read(buf)) > 0) {
                md.update(buf, 0, r);
            }
            byte[] d = md.digest();
            ByteArrayOutputStream sb = new ByteArrayOutputStream(d.length * 2);
            for (byte b : d) {
                int hi = b >> 4 & 0xF;
                int lo = b & 0xF;
                sb.write(HEX.charAt(hi));
                sb.write(HEX.charAt(lo));
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return "unknown";
            }
        }
        in.close();
        return string;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Toasts {
        private static final class_2960 TOAST_TEX = new class_2960("textures/gui/toasts.png");

        public static void info(class_2561 title, class_2561 desc) {
            class_374 tm = class_310.method_1551().method_1566();
            tm.method_1999((class_368)new SimpleToast(title, desc, -1));
        }

        public static void error(class_2561 title, class_2561 desc) {
            class_374 tm = class_310.method_1551().method_1566();
            tm.method_1999((class_368)new SimpleToast(title, desc, -43691));
        }

        public static UploadToast showTrans(String titleKey, String subKey, Object ... args) {
            class_374 tm = class_310.method_1551().method_1566();
            UploadToast t = new UploadToast((class_2561)class_2561.method_43471((String)titleKey), (class_2561)class_2561.method_43469((String)subKey, (Object[])args));
            tm.method_1999((class_368)t);
            return t;
        }

        public static ConnectionToast connection(class_2561 title, class_2561 checkingSub) {
            class_374 tm = class_310.method_1551().method_1566();
            ConnectionToast t = new ConnectionToast(title, checkingSub);
            tm.method_1999((class_368)t);
            try {
                ModSounds.play(ModSounds.UI_UPLOAD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return t;
        }

        public static ConnectionToast connectionTrans(String titleKey, String checkingKey) {
            return Toasts.connection((class_2561)class_2561.method_43471((String)titleKey), (class_2561)class_2561.method_43471((String)checkingKey));
        }

        @Environment(value=EnvType.CLIENT)
        static class SimpleToast
        implements class_368 {
            private final class_2561 title;
            private final class_2561 desc;
            private final int color;
            private long start = -1L;

            SimpleToast(class_2561 title, class_2561 desc, int color) {
                this.title = title;
                this.desc = desc;
                this.color = color;
            }

            public class_368.class_369 method_1986(class_332 ctx, class_374 tm, long time) {
                if (this.start < 0L) {
                    this.start = time;
                }
                ctx.method_25290(TOAST_TEX, 0, 0, 0.0f, 0.0f, 160, 32, 256, 256);
                class_327 tr = class_310.method_1551().field_1772;
                ctx.method_51439(tr, this.title, 8, 7, this.color, false);
                if (this.desc != null) {
                    ctx.method_51439(tr, this.desc, 8, 18, -2236963, false);
                }
                return time - this.start > 3500L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static class UploadToast
        implements class_368 {
            private final class_2561 title;
            private class_2561 subtitle;
            private float progress = 0.0f;
            private boolean done = false;
            private boolean success = false;
            private long start = -1L;

            public UploadToast(class_2561 title, class_2561 subtitle) {
                this.title = title;
                this.subtitle = subtitle;
            }

            public void update(float p, String sub) {
                this.progress = Math.max(0.0f, Math.min(1.0f, p));
                this.subtitle = class_2561.method_43470((String)sub);
            }

            public void complete(boolean ok, String sub) {
                this.success = ok;
                this.done = true;
                this.subtitle = class_2561.method_43470((String)sub);
            }

            public class_368.class_369 method_1986(class_332 ctx, class_374 tm, long time) {
                if (this.start < 0L) {
                    this.start = time;
                }
                ctx.method_25290(TOAST_TEX, 0, 0, 0.0f, 0.0f, 160, 32, 256, 256);
                class_327 tr = class_310.method_1551().field_1772;
                ctx.method_51439(tr, this.title, 8, 7, -1, false);
                if (this.subtitle != null) {
                    ctx.method_51439(tr, this.subtitle, 8, 18, -2236963, false);
                }
                int bx = 8;
                int by = 28;
                int bw = 144;
                int bh = 2;
                ctx.method_25294(bx, by, bx + bw, by + bh, -12303292);
                int pw = (int)((float)bw * this.progress);
                ctx.method_25294(bx, by, bx + pw, by + bh, this.success ? -11141291 : -11162881);
                if (this.done) {
                    return time - this.start > 2200L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
                }
                return class_368.class_369.field_2210;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static class ConnectionToast
        implements class_368 {
            private final class_2561 title;
            private final class_2561 checking;
            private class_2561 result;
            private boolean ok = false;
            private boolean done = false;
            private boolean announced = false;
            private long start = -1L;
            private final long minShowMs = 800L;

            public ConnectionToast(class_2561 title, class_2561 checking) {
                this.title = title;
                this.checking = checking;
            }

            public void complete(boolean ok, String sub) {
                this.ok = ok;
                this.result = class_2561.method_43470((String)sub);
                this.done = true;
                this.announced = false;
            }

            public class_368.class_369 method_1986(class_332 ctx, class_374 tm, long time) {
                int color;
                boolean showResult;
                if (this.start < 0L) {
                    this.start = time;
                }
                ctx.method_25290(TOAST_TEX, 0, 0, 0.0f, 0.0f, 160, 32, 256, 256);
                class_327 tr = class_310.method_1551().field_1772;
                ctx.method_51439(tr, this.title, 8, 7, -1, false);
                long elapsed = time - this.start;
                boolean bl = showResult = this.done && elapsed >= 800L;
                int n = showResult ? (this.ok ? -11141291 : -43691) : (color = -2236963);
                class_2561 sub = showResult ? (this.result != null ? this.result : class_2561.method_43470((String)(this.ok ? "OK" : "ERROR"))) : this.checking;
                ctx.method_51439(tr, sub, 8, 18, color, false);
                if (showResult && !this.announced) {
                    this.announced = true;
                    try {
                        ModSounds.play(this.ok ? ModSounds.UI_COMPLETE : ModSounds.UI_ERROR);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (showResult && elapsed > 2800L) {
                    return class_368.class_369.field_2209;
                }
                return class_368.class_369.field_2210;
            }
        }
    }
}

