/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.api.SoulShardsAPI;
import net.creeperhost.soulshardsrespawn.block.BlockSoulCage;
import net.creeperhost.soulshardsrespawn.block.SoulSpawnerLogic;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.item.ItemSoulShard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntitySoulCage
extends BlockEntity {
    private ItemStackHandler inventory;
    private boolean active = false;
    public int spawnDelay = -1;
    public SoulSpawnerLogic spawnerLogic = new SoulSpawnerLogic(this);
    private Binding binding = null;

    public TileEntitySoulCage(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistrarSoulShards.SOUL_CAGE_TE.get(), blockPos, blockState);
        this.inventory = new SoulCageInventory(){

            protected void onContentsChanged(int slot) {
                TileEntitySoulCage.this.setChanged();
                super.onContentsChanged(slot);
            }
        };
    }

    public void tick() {
        this.updateBinding();
        if (this.level instanceof ServerLevel) {
            boolean newState = this.canSpawn();
            if (newState != this.active) {
                this.setActive(newState);
                this.level.neighborChanged(this.getBlockPos(), this.getBlockState().getBlock(), null);
            }
            this.spawnerLogic.serverTick((ServerLevel)this.level, this.worldPosition);
        } else {
            this.spawnerLogic.clientTick(this.level, this.worldPosition);
        }
    }

    public boolean isActive() {
        return this.active && this.binding != null;
    }

    private boolean canSpawn() {
        BlockState state = this.getBlockState();
        if (state.getBlock() != RegistrarSoulShards.SOUL_CAGE.get()) {
            return false;
        }
        ItemStack shardStack = this.inventory.getStackInSlot(0);
        if (shardStack.isEmpty() || !(shardStack.getItem() instanceof ItemSoulShard)) {
            this.spawnDelay = -1;
            return false;
        }
        if (this.binding == null || this.binding.getBoundEntity() == null) {
            return false;
        }
        IShardTier tier = this.binding.getTier();
        if (tier.getSpawnAmount() == 0) {
            return false;
        }
        if (SoulShards.CONFIG.getBalance().requireOwnerOnline() && !this.ownerOnline()) {
            return false;
        }
        if (!SoulShardsAPI.isAllowed(this.binding.getBoundEntity())) {
            return false;
        }
        if (!SoulShards.CONFIG.getBalance().requireRedstoneSignal() ? (Boolean)state.getValue(BlockSoulCage.POWERED) != false && tier.checkRedstone() : (Boolean)state.getValue(BlockSoulCage.POWERED) == false) {
            return false;
        }
        return !tier.checkPlayer() || this.level.getNearestPlayer((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), 16.0, false) != null;
    }

    protected void resetTimer() {
        this.spawnDelay = this.binding == null ? -1 : this.binding.getTier().getCooldown();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public void setActive(boolean active) {
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof BlockSoulCage)) {
            return;
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue(BlockSoulCage.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        this.active = active;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            ItemStack stack = this.getInventory().getStackInSlot(0);
            Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{stack}));
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.inventory.deserialize(input.childOrEmpty("inventory"));
        this.spawnDelay = input.getIntOr("spawnDelay", -1);
        this.active = input.getBooleanOr("active", false);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.serialize(output.child("inventory"));
        output.putInt("spawnDelay", this.spawnDelay);
        output.putBoolean("active", this.active);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    private void updateBinding() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        this.binding = stack.isEmpty() || !(stack.getItem() instanceof ItemSoulShard) ? null : ((ItemSoulShard)stack.getItem()).getBinding(stack);
    }

    @Nullable
    public Binding getBinding() {
        return this.binding;
    }

    public boolean ownerOnline() {
        Binding binding = this.getBinding();
        return binding != null && binding.getOwner() != null && this.level.getServer().getPlayerList().getPlayer(binding.getOwner()) == null;
    }

    public static class SoulCageInventory
    extends ItemStackHandler {
        public SoulCageInventory() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.getItem() instanceof ItemSoulShard)) {
                return stack;
            }
            Binding binding = ((ItemSoulShard)stack.getItem()).getBinding(stack);
            if (binding == null || binding.getBoundEntity() == null || !SoulShardsAPI.isAllowed(binding.getBoundEntity())) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

