/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.core.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.List;
import java.util.TreeMap;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.core.util.JsonUtil;
import net.neoforged.fml.loading.FMLPaths;

public class Tier
implements IShardTier {
    public static final TreeMap<Integer, IShardTier> TIERS = Maps.newTreeMap();
    public static final List<IShardTier> INDEXED = Lists.newArrayList();
    public static int maxKills;
    private final int killRequirement;
    private final boolean checkPlayer;
    private final boolean checkLight;
    private final boolean checkRedstone;
    private final int spawnAmount;
    private final int cooldown;

    public Tier(int killRequirement, boolean checkPlayer, boolean checkLight, boolean checkRedstone, int spawnAmount, int cooldown) {
        this.killRequirement = killRequirement;
        this.checkPlayer = checkPlayer;
        this.checkLight = checkLight;
        this.checkRedstone = checkRedstone;
        this.spawnAmount = spawnAmount;
        this.cooldown = cooldown;
    }

    @Override
    public int getKillRequirement() {
        return this.killRequirement;
    }

    @Override
    public boolean checkPlayer() {
        return this.checkPlayer;
    }

    @Override
    public boolean checkLight() {
        return this.checkLight;
    }

    @Override
    public boolean checkRedstone() {
        return this.checkRedstone;
    }

    @Override
    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getIndex() {
        return INDEXED.indexOf(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tier)) {
            return false;
        }
        Tier tier = (Tier)object;
        return this.killRequirement == tier.killRequirement;
    }

    public int hashCode() {
        return this.killRequirement;
    }

    public static void readTiers() {
        Tier[] tiers;
        for (Tier tier : tiers = JsonUtil.fromJson(TypeToken.get(Tier[].class), new File(FMLPaths.CONFIGDIR.get().toFile(), "soulshards/tiers.json"), Tier.generateDefaults())) {
            TIERS.put(tier.killRequirement, tier);
            INDEXED.add(tier);
            if (tier.getKillRequirement() <= maxKills) continue;
            maxKills = tier.getKillRequirement();
        }
    }

    private static Tier[] generateDefaults() {
        return new Tier[]{new Tier(0, true, false, false, 0, 0), new Tier(64, true, true, false, 2, 400), new Tier(128, true, true, false, 4, 200), new Tier(256, false, true, false, 4, 100), new Tier(512, false, false, false, 4, 100), new Tier(1024, false, false, true, 6, 40)};
    }
}

