/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.datagen;

import java.util.concurrent.CompletableFuture;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

public class GeneratorRecipes
extends RecipeProvider {
    public GeneratorRecipes(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)Items.SOUL_SAND, RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.VILE_DUST.get(), 1.0f, 200, "soulshards", "_from_soul_sand");
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)Items.SOUL_SOIL, RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.VILE_DUST.get(), 1.0f, 200, "soulshards", "_from_soul_soil");
        this.shaped(RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.VILE_SWORD.get()).pattern(" I ").pattern(" I ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)RegistrarSoulShards.CORRUPTED_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).group("soulshards").unlockedBy("has_vile_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)RegistrarSoulShards.CORRUPTED_INGOT.get()})).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.SOUL_CAGE.get()).pattern("IBI").pattern("B B").pattern("IBI").define(Character.valueOf('I'), (ItemLike)RegistrarSoulShards.CORRUPTED_INGOT.get()).define(Character.valueOf('B'), (ItemLike)Items.IRON_BARS).group("soulshards").unlockedBy("has_vile_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)RegistrarSoulShards.CORRUPTED_INGOT.get()})).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.CORRUPTED_ESSENCE.get()).requires((ItemLike)Items.LAPIS_LAZULI).requires((ItemLike)Items.REDSTONE).requires((ItemLike)Items.OBSIDIAN).requires((ItemLike)Items.OBSIDIAN).group("soulshards").unlockedBy("has_obsidian", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.OBSIDIAN})).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.CORRUPTED_INGOT.get()).pattern("CVC").pattern("VIV").pattern("CVC").define(Character.valueOf('C'), (ItemLike)RegistrarSoulShards.CORRUPTED_ESSENCE.get()).define(Character.valueOf('V'), (ItemLike)RegistrarSoulShards.VILE_DUST.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).group("soulshards").unlockedBy("has_vile_dust", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)RegistrarSoulShards.VILE_DUST.get()})).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RegistrarSoulShards.SOUL_SHARD.get()).requires((ItemLike)RegistrarSoulShards.SOUL_SHARD.get()).group("soulshards").unlockedBy("has_soulshard", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)RegistrarSoulShards.SOUL_SHARD.get()})).save(this.output);
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, ItemLike input, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)result.asItem());
        ResourceKey rskey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"soulshards", (String)("smelting/" + key.getPath() + suffix)));
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(GeneratorRecipes.getHasName((ItemLike)input), this.has(input)).save(this.output, rskey);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput p_365442_, CompletableFuture<HolderLookup.Provider> p_362168_) {
            super(p_365442_, p_362168_);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider p_364945_, RecipeOutput p_362956_) {
            return new GeneratorRecipes(p_364945_, p_362956_);
        }

        public String getName() {
            return "Soul Shards Recipes";
        }
    }
}

