/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.block;

import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BlockSoulCage
extends Block
implements EntityBlock {
    public static final Property<Boolean> POWERED = BooleanProperty.create((String)"powered");
    public static final Property<Boolean> ACTIVE = BooleanProperty.create((String)"active");

    public BlockSoulCage(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(POWERED, (Comparable)Boolean.valueOf(false))).setValue(ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof TileEntitySoulCage) {
                TileEntitySoulCage tile = (TileEntitySoulCage)t;
                tile.tick();
            }
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isSteppingCarefully()) {
            return InteractionResult.PASS;
        }
        TileEntitySoulCage cage = (TileEntitySoulCage)world.getBlockEntity(pos);
        if (cage == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = cage.getInventory().extractItem(0, 1, false);
        if (stack.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        return InteractionResult.SUCCESS;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState state2, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbor, Orientation orientation, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue(POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.setValue(POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @javax.annotation.Nullable Direction side) {
        return true;
    }

    public boolean hasAnalogOutputSignal(BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        TileEntitySoulCage cage = (TileEntitySoulCage)world.getBlockEntity(pos);
        if (cage == null) {
            return 0;
        }
        Binding binding = cage.getBinding();
        if (binding == null) {
            return 0;
        }
        return (int)((double)binding.getTier().getIndex() / ((double)Tier.INDEXED.size() - 1.0) * 15.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, ACTIVE});
    }

    private void handleRedstoneChange(Level world, BlockState state, BlockPos pos) {
        boolean powered = world.hasNeighborSignal(pos);
        if (((Boolean)state.getValue(POWERED)).booleanValue() && !powered) {
            world.setBlock(pos, (BlockState)state.setValue(POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.getValue(POWERED)).booleanValue() && powered) {
            world.setBlock(pos, (BlockState)state.setValue(POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntitySoulCage(blockPos, blockState);
    }
}

