/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.compat.jade;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.creeperhost.soulshardsrespawn.block.BlockSoulCage;
import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.item.ItemSoulShard;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation ENTITY_DATA_ID = ResourceLocation.fromNamespaceAndPath((String)"soulshards", (String)"entity_data");
    private static final ResourceLocation CAGE_DATA_ID = ResourceLocation.fromNamespaceAndPath((String)"soulshards", (String)"cage_data");

    public void register(IWailaCommonRegistration registration) {
        registration.registerEntityDataProvider((IServerDataProvider)new IServerDataProvider<EntityAccessor>(this){

            public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
                tag.putBoolean("cageBorn", accessor.getEntity().getPersistentData().contains("cageBorn"));
            }

            public ResourceLocation getUid() {
                return ENTITY_DATA_ID;
            }
        }, LivingEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
                ItemStack binding = ((TileEntitySoulCage)accessor.getBlockEntity()).getInventory().getStackInSlot(0);
                if (!binding.isEmpty()) {
                    RegistryAccess access = accessor.getLevel().registryAccess();
                    Optional opTag = ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)access.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)binding).result();
                    opTag.ifPresent(e -> tag.put("binding", e));
                }
            }

            public ResourceLocation getUid() {
                return CAGE_DATA_ID;
            }
        }, TileEntitySoulCage.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerEntityComponent((IComponentProvider)new IEntityComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig iPluginConfig) {
                if (accessor.getServerData().getBooleanOr("cageBorn", false)) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.cage_born"));
                }
            }

            public ResourceLocation getUid() {
                return ENTITY_DATA_ID;
            }
        }, LivingEntity.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
                Item item;
                if (!accessor.getServerData().contains("binding")) {
                    return;
                }
                CompoundTag tag = accessor.getServerData().getCompoundOrEmpty("binding");
                if (tag.isEmpty()) {
                    return;
                }
                RegistryAccess access = accessor.getLevel().registryAccess();
                Optional result = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)access.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result();
                if (result.isEmpty()) {
                    return;
                }
                ItemStack stack = result.orElse(ItemStack.EMPTY);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemSoulShard)) {
                    return;
                }
                ItemSoulShard itemSoulShard = (ItemSoulShard)item;
                Binding binding = itemSoulShard.getBinding(stack);
                if (binding == null) {
                    return;
                }
                if (binding.getBoundEntity() != null) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.bound", (Object[])new Object[]{binding.getBoundEntity().toString()}));
                }
                tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.tier", (Object[])new Object[]{binding.getTier().getIndex()}));
            }

            public ResourceLocation getUid() {
                return CAGE_DATA_ID;
            }
        }, BlockSoulCage.class);
    }
}

