/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorBlockLoot;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorBlockTags;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorEntityTags;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorItemTags;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="soulshards")
public class SoulShardDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        SoulShardDataGen.registerProviders(event.getGenerator(), event.getLookupProvider());
    }

    public static void registerProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        generator.addProvider(true, (DataProvider)new GeneratorRecipes.Runner(generator.getPackOutput(), lookupProvider));
        GeneratorBlockTags blockTags = new GeneratorBlockTags(generator.getPackOutput(), lookupProvider, "soulshards");
        generator.addProvider(true, (DataProvider)blockTags);
        GeneratorItemTags itemTags = new GeneratorItemTags(generator.getPackOutput(), lookupProvider);
        generator.addProvider(true, (DataProvider)itemTags);
        generator.addProvider(true, (DataProvider)new GeneratorEntityTags(generator.getPackOutput(), lookupProvider));
        generator.addProvider(true, (DataProvider)new LootTableProvider(generator.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(GeneratorBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)new GeneratorLanguage(generator));
    }

    public static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(DataGenerator gen) {
            super(gen.getPackOutput(), "soulshards", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.soulshards", "Soul Shards Respawn");
            this.add((Item)RegistrarSoulShards.SOUL_SHARD.get(), "Soul Shard");
            this.add("item.soulshards.soul_shard_unbound", "Unbound Soul Shard");
            this.add((Item)RegistrarSoulShards.CORRUPTED_INGOT.get(), "Corrupted Ingot");
            this.add((Item)RegistrarSoulShards.CORRUPTED_ESSENCE.get(), "Corrupted Essence");
            this.add((Item)RegistrarSoulShards.VILE_DUST.get(), "Vile Dust");
            this.add((Item)RegistrarSoulShards.VILE_SWORD.get(), "Vile Sword");
            this.add((Block)RegistrarSoulShards.SOUL_CAGE.get(), "Soul Cage");
            this.add((Item)RegistrarSoulShards.SOUL_CAGE_ITEM.get(), "Soul Cage");
            this.add("tooltip.soulshards.bound", "Bound to: %s");
            this.add("tooltip.soulshards.kills", "Souls: %d");
            this.add("tooltip.soulshards.tier", "Tier: %d");
            this.add("tooltip.soulshards.owner", "Owner: %s");
            this.add("tooltip.soulshards.cage_born", "Cage Born");
            this.add("enchantment.soulshards.soul_stealer", "Soul Stealer");
            this.add("chat.soulshards.absorb_disabled", "\u00a7cThe shard seems to refuse the trapped soul...");
            this.add("chat.soulshards.command_killed", "\u00a72Killed \u00a72%d \u00a72entities");
            this.add("chat.soulshards.command_not_found", "\u00a7cDid not find any spawned entities");
            this.add("commands.soulshards.usage", "/soulshards [setEnt|setKills|setOwner|killall]");
            this.add("commands.soulshards.set_ent.usage", "/soulshards setEnt <entityId>");
            this.add("commands.soulshards.set_ent.success", "Set bound entity of held shard to %s.");
            this.add("commands.soulshards.set_kills.usage", "/soulshards setKills <killCount>");
            this.add("commands.soulshards.set_kills.success", "Set kill count of held shard to %d.");
            this.add("commands.soulshards.set_owner.usage", "/soulshards setOwner [owner]");
            this.add("commands.soulshards.set_owner.success", "Set owner of held shard to %s.");
            this.add("commands.soulshards.kill_all.usage", "/soulshards killall");
            this.add("commands.soulshards.kill_all.success", "Killed %d cage born entities.");
            this.add("commands.soulshards.error.not_a_shard", "Held item is not a Soul Shard.");
            this.add("commands.soulshards.error.not_a_entity", "%s is invalid or not registered.");
            this.add("enchantment.soulshards.soul_stealer.desc", "Increases the souls collected per kill by one per level.");
            this.add("jei.soulshards.soul_shard.desc", "A vessel for the Souls of the slain.\\n\\nObtained by creating a structure in the world and using a %s on the origin block.");
            this.add("jei.soulshards.soul_shard.title", "Soul Shard Crafting");
            this.add("jei.soulshards.soul_shard.creation", "Right-click on the top\nof the \u00a75Glowstone Block\u00a7r\nwith a %s in hand");
            this.add("jei.soulshards.soul_shard.multiblock", "4x Obsidian\n4x Block of Quartz\n1x Glowstone");
            this.add("config.jade.plugin_soulshards.cage_data", "Soul Cage Data");
            this.add("config.jade.plugin_soulshards.entity_data", "Soul Cage Entity");
        }
    }
}

